/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiPixelRenderer;

public class ConvolutionFilter
extends MultiPixelRenderer {
    protected static final String UNIFORM_FILTER = "u_Filter";
    private float[] filter;
    private int filterHandle;
    private String filterBody;
    private int filterSize;

    public ConvolutionFilter(float[] filter, int filterWidth, int filterHeight) {
        this.filter = filter;
        this.filterBody = this.createFilterBody(filterWidth, filterHeight);
        this.filterSize = filterWidth * filterHeight;
    }

    private String createFilterBody(int width, int height) {
        String string = "   vec3 color = ";
        int n = (width - 1) / 2;
        int n2 = (height - 1) / 2;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                string = string + "   texture2D(inputImageTexture0,textureCoordinate + widthStep * " + (j - n) + ".0 + heightStep * " + (i - n2) + ".0).rgb * " + UNIFORM_FILTER + "[" + (i * width + j) + "]";
                string = j == width - 1 && i == height - 1 ? string + ";\n" : string + " +\n";
            }
        }
        string = string + "   gl_FragColor = vec4(color, 1);\n";
        return string;
    }

    private int getFilterSize() {
        return this.filterSize;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform float u_TexelWidth;\nuniform float u_TexelHeight;\nuniform float u_Filter[" + this.getFilterSize() + "];" + "varying vec2 " + "textureCoordinate" + ";\n" + "void main(){\n" + "   vec2 widthStep = vec2(" + "u_TexelWidth" + ", 0);" + "   vec2 heightStep = vec2(0, " + "u_TexelHeight" + ");" + this.filterBody + "}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.filterHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_FILTER);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1fv((int)this.filterHandle, (int)this.filterSize, (float[])this.filter, (int)0);
    }
}

