/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import java.io.File;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.helper.ImageHelper;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.model.FilterOptions;

public class ColorChangedFilter
extends AbsEffectOptionFilter {
    private String[] lookupPaths;
    private int[] textures;
    private int[] textureHandle;
    private int timeHandler;
    private float time;
    private int frameCost = 150;
    private int colorNum;

    public ColorChangedFilter() {
        this.init();
    }

    public ColorChangedFilter(FilterOptions options) {
        this.init();
        this.setFilterOptions(options);
    }

    private void init() {
        this.colorNum = 2;
        this.textures = new int[this.colorNum];
        this.textureHandle = new int[this.colorNum];
        this.lookupPaths = new String[this.colorNum];
    }

    @Override
    public void setFilterOptions(FilterOptions options) {
        super.setFilterOptions(options);
        this.lookupPaths[0] = options.getFolder() + File.separator + "lut_0.png";
        this.lookupPaths[1] = options.getFolder() + File.separator + "lut_1.png";
        this.frameCost = options.getFrameCost();
    }

    @Override
    protected String getFragmentShader() {
        return "precision highp float;\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nuniform float uTime;\n\nconst float pi = 3.14159;\nconst float stepDis = 1.0 / 8.0;\nconst float perPixel = 1.0 / 512.0;\nconst float halfPixel = 0.5 / 512.0;\n\nvec4 lookup(vec4 color, sampler2D lookupTexture) {\n    float blue = color.b * 63.0;\n    vec2 coord;\n    coord.y = floor(blue / 8.0);\n    coord.x = floor(blue) - (coord.y * 8.0);\n    coord = coord * stepDis + halfPixel + (stepDis - perPixel) * color.xy;\n    return texture2D(lookupTexture, coord);\n}\n\nvoid main() {\n    vec4 inputColor = texture2D(inputImageTexture, textureCoordinate);\n    vec4 lookupColor1 = lookup(inputColor, inputImageTexture1);\n    vec4 lookupColor2 = lookup(inputColor, inputImageTexture2);\n\n    float density = sin(uTime);\n    density = ((density + 1.0) / 2.0);\n\tgl_FragColor = mix(lookupColor2, lookupColor1, density);\n}";
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.textures[i] != 0) continue;
            this.textures[i] = ImageHelper.bitmapToTexture(ImageHelper.getBitmapByPath(this.lookupPaths[i]));
        }
        super.newTextureReady(texture, source, newData);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        for (int i = 0; i < this.colorNum; ++i) {
            this.textureHandle[i] = GLES20.glGetUniformLocation((int)this.programHandle, (String)("inputImageTexture" + (i + 1)));
        }
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"uTime");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.passTextureValues();
        this.time = this.frameCost > 0 ? (float)((double)this.time + Math.PI / (double)this.frameCost) : (float)((double)((float)(System.currentTimeMillis() % 100000L) / 1000.0f) * Math.PI);
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    protected void passTextureValues() {
        int n = 0;
        for (int i = 0; i < this.colorNum; ++i) {
            switch (i) {
                case 0: {
                    n = 33985;
                    break;
                }
                case 1: {
                    n = 33986;
                }
            }
            GLES20.glActiveTexture((int)n);
            GLES20.glBindTexture((int)3553, (int)this.textures[i]);
            GLES20.glUniform1i((int)this.textureHandle[i], (int)(i + 1));
        }
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        this.deleteTextures();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.deleteTextures();
    }

    private void deleteTextures() {
        for (int i = 0; i < this.textures.length; ++i) {
            if (this.textures[i] <= 0) continue;
            int[] nArray = new int[1];
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.textures[i] = 0;
        }
    }
}

