/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class CamMultiplyFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String UNIFORM_TIME = "iTime";
    private int timeHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float iTime;\nvoid main(){\n    vec2 uv = textureCoordinate;\n    uv.x = 1.0 - uv.x;\n    vec3 col = texture2D(inputImageTexture0,uv).xyz;\n    vec3 greyMul = vec3(0.2989, 0.5870, 0.1140);\n    vec3 greyCol = col * greyMul;\n    float grey = greyCol.x + greyCol.y + greyCol.z;\n    float threshold = 0.5 + 0.5 * sin(iTime * 2.0);\n    if ( grey > threshold - 0.2 && grey < threshold + 0.2 )\n    {\n        float u = mod(uv.x * 4.0, 1.0);\n        float v = mod(uv.y * 4.0, 1.0);\n        col = texture2D(inputImageTexture0,vec2(u,v)).xyz * vec3(uv,0.5+0.5*sin(iTime * 4.0));\n    }\n        \n    gl_FragColor = vec4(col,1.0);\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    public void setTimeStamp(long ms) {
        long l = ms % this.duration;
        this.time = (float)l / 1000.0f;
        this.useInnerTime = false;
    }
}

