/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.processing.SobelEdgeDetectionFilter;

public class BlackHoleFilter
extends SobelEdgeDetectionFilter {
    public static final String UNIFORM_TIME = "time";
    private int timeHandler;
    public static final String UNIFORM_WIDTH = "width";
    private int widthHandler;
    public static final String UNIFORM_HEIGHT = "height";
    private int heightHandler;
    private float time = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    @Override
    protected String getFragmentShader() {
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_TexelWidth;\nuniform float u_TexelHeight;\nuniform float time;\nuniform float width;\nuniform float height;\nfloat d;\n\nfloat lookup(vec2 p, float dx, float dy)\n{\n    vec2 uv = (p.xy + vec2(dx * d, dy * d))/ vec2(width,height);\n    vec4 c = texture2D(inputImageTexture0, uv.xy);\n    return 0.2126*c.r + 0.7152*c.g + 0.0722*c.b;\n}\nvoid main(){\n   vec2 up = vec2(0.0, u_TexelHeight);\n   vec2 right = vec2(u_TexelWidth, 0.0);\n   float bottomLeftIntensity = texture2D(inputImageTexture0, textureCoordinate - up - right).r;\n   float topRightIntensity = texture2D(inputImageTexture0, textureCoordinate + up + right).r;\n   float topLeftIntensity = texture2D(inputImageTexture0, textureCoordinate + up - right).r;\n   float bottomRightIntensity = texture2D(inputImageTexture0, textureCoordinate - up + right).r;\n   float leftIntensity = texture2D(inputImageTexture0, textureCoordinate - right).r;\n   float rightIntensity = texture2D(inputImageTexture0, textureCoordinate + right).r;\n   float bottomIntensity = texture2D(inputImageTexture0, textureCoordinate - up).r;\n   float topIntensity = texture2D(inputImageTexture0, textureCoordinate + up).r;\n   float h = -topLeftIntensity - 2.0 * topIntensity - topRightIntensity + bottomLeftIntensity + 2.0 * bottomIntensity + bottomRightIntensity;\n   float v = -bottomLeftIntensity - 2.0 * leftIntensity - topLeftIntensity + bottomRightIntensity + 2.0 * rightIntensity + topRightIntensity;\n    d = sin(time * 5.0)*0.5 + 1.5;\n    vec2 p = textureCoordinate* vec2(width,height);\n    float gx = 0.0;\n    gx += -1.0 * lookup(p, -1.0, -1.0);\n    gx += -2.0 * lookup(p, -1.0,  0.0);\n    gx += -1.0 * lookup(p, -1.0,  1.0);\n    gx +=  1.0 * lookup(p,  1.0, -1.0);\n    gx +=  2.0 * lookup(p,  1.0,  0.0);\n    gx +=  1.0 * lookup(p,  1.0,  1.0);\n    float gy = 0.0;\n    gy += -1.0 * lookup(p, -1.0, -1.0);\n    gy += -2.0 * lookup(p,  0.0, -1.0);\n    gy += -1.0 * lookup(p,  1.0, -1.0);\n    gy +=  1.0 * lookup(p, -1.0,  1.0);\n    gy +=  2.0 * lookup(p,  0.0,  1.0);\n    gy +=  1.0 * lookup(p,  1.0,  1.0);\n    float g = gx*gx + gy*gy;\n    float g2 = g * (sin(time) / 2.0);\n    vec4 col;\n    if (tan(time) > 0.9) {\n       col = texture2D(inputImageTexture0, textureCoordinate);\n    } else {       float mag = length(vec2(h, v));\n       col = vec4(vec3(mag), 1.0);\n    }    col += vec4(g*2.0, g2*2.0, 0.0, 1.0);\n   gl_FragColor = col;\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
        this.widthHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_WIDTH);
        this.heightHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HEIGHT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
        GLES20.glUniform1f((int)this.widthHandler, (float)this.getWidth());
        GLES20.glUniform1f((int)this.heightHandler, (float)this.getHeight());
    }
}

