/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.processing;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ArtifactFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String UNIFORM_COLORIZATION = "colorization";
    public static final String UNIFORM_NOISE = "noise";
    public static final String UNIFORM_PARASITE = "parasite";
    public static final String UNIFORM_FADE = "fade";
    public static final String UNIFORM_TIME = "time";
    public static final String UNIFORM_COUNT = "count";
    private static final String UNIFORM_START = "isStart";
    private int startHandle;
    private long mStartTime = 0L;
    private long mEndTime = 0L;
    private long mPlayTime = 0L;
    private int mCount = 0;
    private long mDuration = 4000L;
    private int colorizationHandler;
    private int noiseHandler;
    private int parasiteHandler;
    private int fadeHandler;
    private int timeHandler;
    private int countHandler;
    private float colorization = 1.0f;
    private float noise = 1.0f;
    private float parasite = 1.0f;
    private float fade = 1.0f;
    private float time = 0.0f;
    private float count = 0.0f;
    private boolean useInnerTime = true;
    private long duration = 100000L;

    public ArtifactFilter(long mDuration) {
        this.mDuration = mDuration;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.colorizationHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLORIZATION);
        this.noiseHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_NOISE);
        this.parasiteHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_PARASITE);
        this.fadeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_FADE);
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
        this.countHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COUNT);
        this.mStartTime = System.currentTimeMillis();
        this.startHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_START);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        this.count += 1.0f;
        if (this.useInnerTime) {
            this.time = (float)(System.currentTimeMillis() % this.duration) / 1000.0f;
        }
        GLES20.glUniform1f((int)this.colorizationHandler, (float)this.colorization);
        GLES20.glUniform1f((int)this.noiseHandler, (float)this.noise);
        GLES20.glUniform1f((int)this.parasiteHandler, (float)this.parasite);
        GLES20.glUniform1f((int)this.fadeHandler, (float)this.fade);
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
        GLES20.glUniform1f((int)this.countHandler, (float)this.count);
        this.mEndTime = System.currentTimeMillis() - this.mStartTime;
        long l = this.mEndTime / this.mDuration;
        this.mEndTime -= l * this.mDuration;
        if (this.mEndTime >= this.mPlayTime && this.mCount < 6) {
            GLES20.glUniform1f((int)this.startHandle, (float)1.0f);
            ++this.mCount;
        } else if (this.mEndTime >= this.mPlayTime && this.mCount >= 6) {
            GLES20.glUniform1f((int)this.startHandle, (float)0.0f);
        } else {
            GLES20.glUniform1f((int)this.startHandle, (float)0.0f);
            this.mCount = 0;
        }
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform float colorization;\nuniform float noise;\nuniform float parasite;\nuniform float fade;\nuniform float time;\nvarying vec2 textureCoordinate;\nuniform float count;\nuniform float isStart;\nfloat rng2(vec2 seed, float time)\n{\n    return fract(sin(dot(seed * floor(time * 12.0), vec2(127.1,311.7))) * 43758.5453123);\n}\nfloat rng(float seed, float time)\n{\n    return rng2(vec2(seed, 1.0), time);\n}\nvoid main(){\n   vec2 uv = textureCoordinate;\n if (isStart == 1.0) {   vec4 col2;\n   vec4 col3;\n   float lineNoise;\n   vec2 blockS = floor(uv * vec2(24.0,9.0));\n   vec2 blockL = floor(uv * vec2(8.0,4.0));\n   float r = rng2(uv,time);\n   if (uv.y > 0.0 && uv.y < 0.2 && mod(count,4.0) == 0.0){\n      lineNoise = pow(rng2(blockS, time), 0.0) * parasite * pow(rng2(blockL, time), 0.0) ;\n   } else if (uv.y > 0.2 && uv.y < 0.4 && mod(count,8.0) == 0.0){\n      lineNoise = pow(rng2(blockS, time), 0.0) * parasite * pow(rng2(blockL, time), 0.0) ;\n   } else {      lineNoise = pow(rng2(blockS, time), 50.0) * parasite * pow(rng2(blockL, time), 3.0) ;\n   }\n   vec4 col1 = texture2D(inputImageTexture0,uv).rgba;\n   col2 = texture2D(inputImageTexture0,uv + vec2(0, lineNoise * 0.03 * rng(5.0, time)));\n   vec4 result = vec4(vec3(col2.x, col2.y, col2.z), 1.0);\n   result = mix(col1,result,fade);\n   gl_FragColor = result;\n} else {\n   vec4 color = texture2D(inputImageTexture0, vec2(textureCoordinate));\n   gl_FragColor = color;\n}}\n";
        return string;
    }

    @Override
    public void setTimeStamp(long ms) {
        long l = ms % this.duration;
        this.time = (float)l / 1000.0f;
        this.useInnerTime = false;
    }

    public void setColorization(float colorization) {
        this.colorization = colorization;
    }

    public void setNoise(float noise) {
        this.noise = noise;
    }

    public void setParasite(float parasite) {
        this.parasite = parasite;
    }

    public void setFade(float fade) {
        this.fade = fade;
    }

    public void setPlayTime(long ms) {
        this.mPlayTime = ms;
    }
}

