/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.glitter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class MixGlitterFilter
extends MultiInputFilter {
    public static final String UNIFORM_U_COLOR = "uCOLOR";
    public static final String UNIFORM_U_TONE = "uTONE";
    public static final String UNIFORM_U_FX = "uFX";
    int handlerColor;
    int handlerTone;
    int handlerFX;
    float[] uColor = new float[3];
    float[] uTone = new float[3];
    float[] uFx = new float[3];
    String fragmentShader = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture0;//\u539f\u56fe\nuniform sampler2D inputImageTexture1;//\u661f\u661f\nuniform vec3 uCOLOR;\nuniform vec3 uTONE;\nuniform vec3 uFX;\nconst vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);\nconst vec3 AvgLumin = vec3(0.5, 0.5, 0.5);\nvoid main(){ \n    vec3 col2; \n    vec3 col = texture2D(inputImageTexture0, textureCoordinate).rgb; \n    col2 = col * uTONE.y; \n\n    if(uFX.z>0.0) col+=(col-col2)*uFX.z; \n    if(uFX.x>0.0) col = 1.0 - (1.0 - col2*uFX.x) * (1.0 - col); \n\n    col2 = col * uTONE.y; \n    col = pow(mix(AvgLumin, mix(vec3(dot(col2, LumCoeff)), col2, uTONE.x), uTONE.z),uCOLOR); //uTone.x \u8c03\u8282\u9971\u548c\u5ea6\uff0c0\u9971\u548c\u5ea6\u6700\u4f4e\uff0c1\u9971\u548c\u5ea6\u6700\u9ad8\u3002 uTone.z \u8c03\u8282\u5bf9\u6bd4\u5ea6\uff0c0\u5bf9\u6bd4\u5ea6\u6700\u4f4e\uff0c1\u5bf9\u6bd4\u5ea6\u6700\u9ad8\n\n    col = clamp(col,0.0,1.0); \n\n    col += texture2D(inputImageTexture1, textureCoordinate).rgb; \n\n    if(uFX.y>0.0) col*=pow(1.0 - length(0.5 - textureCoordinate) / length(vec2(0.5)),uFX.y); \n\n    gl_FragColor = vec4(col, 1.0); \n}";
    String shader = "precision highp float;\nvarying vec2 TexCoord;\nuniform sampler2D sceneTex;//\u539f\u56fe\nuniform sampler2D blurTex;//\u661f\u661f\nuniform sampler2D softTex;//\u539f\u56fe\u7684\u6a21\u7cca\u56fe\nuniform vec3 uCOLOR;\nuniform vec3 uTONE;\nuniform vec3 uFX;\nconst vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);\nconst vec3 AvgLumin = vec3(0.5, 0.5, 0.5);\nvoid main(){ \n    vec3 col2; \n    vec3 col = texture2D(sceneTex, TexCoord).rgb; \n    col2 = texture2D(softTex, TexCoord).rgb; \n\n    if(uFX.z>0.0) col+=(col-col2)*uFX.z; \n    if(uFX.x>0.0) col = 1.0 - (1.0 - col2*uFX.x) * (1.0 - col); \n\n    col2 = col * uTONE.y; \n    col = pow(mix(AvgLumin, mix(vec3(dot(col2, LumCoeff)), col2, uTONE.x), uTONE.z),uCOLOR); //uTone.x \u8c03\u8282\u9971\u548c\u5ea6\uff0c0\u9971\u548c\u5ea6\u6700\u4f4e\uff0c1\u9971\u548c\u5ea6\u6700\u9ad8\u3002 uTone.z \u8c03\u8282\u5bf9\u6bd4\u5ea6\uff0c0\u5bf9\u6bd4\u5ea6\u6700\u4f4e\uff0c1\u5bf9\u6bd4\u5ea6\u6700\u9ad8\n\n    col = clamp(col,0.0,1.0); \n\n    col += texture2D(blurTex, TexCoord).rgb; \n\n    if(uFX.y>0.0) col*=pow(1.0 - length(0.5 - TexCoord) / length(vec2(0.5)),uFX.y); \n\n    gl_FragColor = vec4(col, 1.0); \n}";

    public MixGlitterFilter() {
        super(2);
        this.setFloatTexture(true);
    }

    public void setColor(float x, float y, float z) {
        this.uColor[0] = x;
        this.uColor[1] = y;
        this.uColor[2] = z;
    }

    public void setTone(float x, float y, float z) {
        this.uTone[0] = x;
        this.uTone[1] = y;
        this.uTone[2] = z;
    }

    public void setFx(float x, float y, float z) {
        this.uFx[0] = x;
        this.uFx[1] = y;
        this.uFx[2] = z;
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
        this.handlerColor = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_U_COLOR);
        this.handlerTone = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_U_TONE);
        this.handlerFX = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_U_FX);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform3f((int)this.handlerColor, (float)this.uColor[0], (float)this.uColor[1], (float)this.uColor[2]);
        GLES20.glUniform3f((int)this.handlerTone, (float)this.uTone[0], (float)this.uTone[1], (float)this.uTone[2]);
        GLES20.glUniform3f((int)this.handlerFX, (float)this.uFx[0], (float)this.uFx[1], (float)this.uFx[2]);
    }

    @Override
    protected String getFragmentShader() {
        return this.fragmentShader;
    }
}

