/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.glitter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class MixDownStarFilter
extends MultiInputFilter {
    public static final String UNIFORM_MIX_COEFF = "mixCoeff";
    private int handlerMixCoeff;
    private float[] mixCoeff = new float[3];
    String shader = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform vec3 mixCoeff;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform sampler2D inputImageTexture2;\nvoid main() {\n    gl_FragColor = texture2D(inputImageTexture0, textureCoordinate)*mixCoeff.x + texture2D(inputImageTexture1, textureCoordinate)*mixCoeff.y + texture2D(inputImageTexture2, textureCoordinate)*mixCoeff.z;\n}";

    public MixDownStarFilter() {
        super(3);
        this.setFloatTexture(true);
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
        this.handlerMixCoeff = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MIX_COEFF);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform3f((int)this.handlerMixCoeff, (float)this.mixCoeff[0], (float)this.mixCoeff[1], (float)this.mixCoeff[2]);
    }

    public void setMixCoeff(float x, float y, float z) {
        this.mixCoeff[0] = x;
        this.mixCoeff[1] = y;
        this.mixCoeff[2] = z;
    }

    @Override
    protected String getFragmentShader() {
        return this.shader;
    }
}

