/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.glitter;

import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;
import project.android.imageprocessing.filter.glitter.BlurStarFilter;
import project.android.imageprocessing.filter.glitter.ExpandFilter;
import project.android.imageprocessing.filter.glitter.ExtractHighLightFilter;
import project.android.imageprocessing.filter.glitter.HaloBlurFilter;
import project.android.imageprocessing.filter.glitter.IsoHeightBlurFilter;
import project.android.imageprocessing.filter.glitter.MixDownStarFilter;
import project.android.imageprocessing.filter.glitter.MixGlitterFilter;
import project.android.imageprocessing.filter.glitter.StarFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class GlitterFilter
extends GroupFilter {
    int renderWidth;
    int renderHeight;
    NormalFilter normalFilter;
    HaloBlurFilter gaussianBlurFilter;
    ExpandFilter expandFilter;
    ExtractHighLightFilter highLightFilter;
    IsoHeightBlurFilter isoHeightBlurFilter;
    StarFilter starFilter;
    BlurStarFilter blurStar;
    MixDownStarFilter mixStar;
    MixGlitterFilter mixGlitterFilter;
    private boolean init = false;

    private void initGlitterFilter(int width, int height) {
        this.renderWidth = width;
        this.renderHeight = height;
        this.normalFilter = new NormalFilter();
        this.expandFilter = new ExpandFilter(this.renderWidth / 4, this.renderHeight / 4);
        this.gaussianBlurFilter = new HaloBlurFilter(this.renderWidth / 4, this.renderHeight / 4);
        this.gaussianBlurFilter.setRenderSize(this.renderWidth / 4, this.renderHeight / 4);
        this.highLightFilter = new ExtractHighLightFilter();
        this.isoHeightBlurFilter = new IsoHeightBlurFilter(this.renderWidth / 4, this.renderHeight / 4);
        this.isoHeightBlurFilter.setRenderSize(this.renderWidth / 4, this.renderHeight / 4);
        this.starFilter = new StarFilter(this.renderWidth / 4, this.renderHeight / 4);
        this.blurStar = new BlurStarFilter(this.renderWidth / 4, this.renderHeight / 4);
        this.mixStar = new MixDownStarFilter();
        this.mixStar.setMixCoeff(0.8f, 0.6f, 1.4f);
        this.mixGlitterFilter = new MixGlitterFilter();
        this.mixGlitterFilter.setColor(1.0f, 1.0f, 1.0f);
        this.mixGlitterFilter.setTone(1.0f, 1.0f, 1.0f);
        this.mixGlitterFilter.setFx(0.0f, 0.0f, 0.0f);
        this.normalFilter.addTarget(this.expandFilter);
        this.normalFilter.addTarget(this.gaussianBlurFilter);
        this.expandFilter.addTarget(this.highLightFilter);
        this.gaussianBlurFilter.addTarget(this.highLightFilter);
        this.highLightFilter.registerFilterLocation(this.expandFilter, 0);
        this.highLightFilter.registerFilterLocation(this.gaussianBlurFilter, 1);
        this.highLightFilter.addTarget(this.isoHeightBlurFilter);
        this.highLightFilter.addTarget(this.starFilter);
        this.starFilter.addTarget(this.blurStar);
        this.isoHeightBlurFilter.addTarget(this.mixStar);
        this.starFilter.addTarget(this.mixStar);
        this.blurStar.addTarget(this.mixStar);
        this.mixStar.registerFilterLocation(this.isoHeightBlurFilter);
        this.mixStar.registerFilterLocation(this.starFilter);
        this.mixStar.registerFilterLocation(this.blurStar);
        this.normalFilter.addTarget(this.mixGlitterFilter);
        this.mixStar.addTarget(this.mixGlitterFilter);
        this.mixGlitterFilter.registerFilterLocation(this.normalFilter);
        this.mixGlitterFilter.registerFilterLocation(this.mixStar);
        this.mixGlitterFilter.addTarget(this);
        this.registerInitialFilter(this.normalFilter);
        this.registerFilter(this.expandFilter);
        this.registerFilter(this.gaussianBlurFilter);
        this.registerFilter(this.highLightFilter);
        this.registerFilter(this.isoHeightBlurFilter);
        this.registerFilter(this.starFilter);
        this.registerFilter(this.blurStar);
        this.registerFilter(this.mixStar);
        this.registerTerminalFilter(this.mixGlitterFilter);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (!this.init && source != null && source.getWidth() != 0 && source.getHeight() != 0) {
            this.initGlitterFilter(source.getWidth(), source.getHeight());
            this.init = true;
        }
        super.newTextureReady(texture, source, newData);
    }
}

