/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.glitter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class ExtractHighLightFilter
extends MultiInputFilter {
    public static final String UNIFORM_THRESHOLD = "threshold";
    public static final String UNIFORM_SCALAR = "scalar";
    public static final String UNIFORM_HLVIG = "HLVig";
    public static final String UNIFORM_GRAY_SCALE = "grayScale";
    private int handlerThreshold;
    private int handlerScalar;
    private int handlerHLVig;
    private int handlerGrayScale;
    private float threshold = 0.85f;
    private float scalar = 15.0f;
    private float HLVig = 0.35f;
    private boolean grayScale = true;
    String fragmentShader = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform float threshold;\nuniform float scalar;\nuniform float HLVig;\nuniform bool grayScale;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nconst vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);\nvoid main() { \n    vec3 col=texture2D(inputImageTexture0, textureCoordinate).rgb; \n    vec3 blu=texture2D(inputImageTexture1, textureCoordinate).rgb;\n    if(grayScale){\n        float v=col.r*0.299+col.g*0.587+col.b*0.114;\n        float v2=blu.r*0.299+blu.g*0.587+blu.b*0.114+HLVig;\n        float th=max(threshold,v2); \n        if(v>th){ \n            v=(v-th)/(1.0-th)*scalar;\n            gl_FragColor=vec4(v,v,v,1.0); \n        }  else{ \n            gl_FragColor=vec4(0.0,0.0,0.0,1.0); \n        }\n    } else { \n        vec3 thc=max(vec3(threshold),blu+HLVig);\n        col.r=(col.r>thc.r)?((col.r-thc.r)/(1.0-thc.r)*scalar):0.0;\n        col.g=(col.g>thc.g)?((col.g-thc.g)/(1.0-thc.g)*scalar):0.0;\n        col.b=(col.b>thc.b)?((col.b-thc.b)/(1.0-thc.b)*scalar):0.0;\n        gl_FragColor=vec4(col,1.0); \n    }\n }";

    public ExtractHighLightFilter() {
        super(2);
        this.setFloatTexture(true);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.handlerThreshold = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_THRESHOLD);
        this.handlerScalar = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SCALAR);
        this.handlerHLVig = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_HLVIG);
        this.handlerGrayScale = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_GRAY_SCALE);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.handlerThreshold, (float)this.threshold);
        GLES20.glUniform1f((int)this.handlerScalar, (float)this.scalar);
        GLES20.glUniform1f((int)this.handlerHLVig, (float)this.HLVig);
        GLES20.glUniform1i((int)this.handlerGrayScale, (int)(this.grayScale ? 1 : 0));
    }

    @Override
    public String getFragmentShader() {
        return this.fragmentShader;
    }
}

