/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.glitter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class ExpandFilter
extends BasicFilter {
    final String UNIFORM_TWO_TEXEL_SIZE = "twoTexelSize";
    int handlerTwoTexelSize;
    float[] twoTexelSize = new float[2];
    String vertexShader = "precision highp float;\nattribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform vec2 twoTexelSize;\nvarying vec2 TexCoord1;\nvarying vec2 TexCoord2;\nvarying vec2 TexCoord3;\nvarying vec2 TexCoord4;\nvoid main(){ \nTexCoord1 = inputTextureCoordinate;\nTexCoord2 = inputTextureCoordinate + vec2(twoTexelSize.x, 0);\nTexCoord3 = inputTextureCoordinate + vec2(twoTexelSize.x, twoTexelSize.y);\nTexCoord4 = inputTextureCoordinate + vec2(0, twoTexelSize.y);\ngl_Position = position; \n}";
    String fragmentShader = "precision highp float;\nvarying vec2 TexCoord1;\nvarying vec2 TexCoord2;\nvarying vec2 TexCoord3;\nvarying vec2 TexCoord4;\nuniform sampler2D inputImageTexture0;\nvoid main(){ \n   gl_FragColor= max(max(texture2D(inputImageTexture0, TexCoord1), texture2D(inputImageTexture0, TexCoord2)), max(texture2D(inputImageTexture0, TexCoord3), texture2D(inputImageTexture0, TexCoord4))); \n}";

    public ExpandFilter(int width, int height) {
        this.setRenderSize(width, height);
        this.twoTexelSize[0] = 1.0f / (float)width;
        this.twoTexelSize[1] = 1.0f / (float)height;
        this.setFloatTexture(true);
    }

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
        this.handlerTwoTexelSize = GLES20.glGetUniformLocation((int)this.programHandle, (String)"twoTexelSize");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.handlerTwoTexelSize, (float)this.twoTexelSize[0], (float)this.twoTexelSize[1]);
    }

    @Override
    public String getFragmentShader() {
        return this.fragmentShader;
    }

    @Override
    public String getVertexShader() {
        return this.vertexShader;
    }
}

