/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.glitter;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class DrawStarStreakOnePassFilter
extends BasicFilter {
    public static final String UNIFORM_STEP_SIZE = "stepSize";
    public static final String UNIFORM_STRIDE = "Stride";
    public static final String UNIFORM_COLOR_COEFF1 = "colorCoeff1";
    public static final String UNIFORM_COLOR_COEFF2 = "colorCoeff2";
    public static final String UNIFORM_COLOR_COEFF3 = "colorCoeff3";
    public static final String UNIFORM_COLOR_COEFF4 = "colorCoeff4";
    int handlerStepSize;
    int handlerStride;
    int handlerCoeff1;
    int handlerCoeff2;
    int handlerCoeff3;
    int handlerCoeff4;
    private float[] stepSize = new float[2];
    private float stride;
    private float[] coeff1 = new float[4];
    private float[] coeff2 = new float[4];
    private float[] coeff3 = new float[4];
    private float[] coeff4 = new float[4];
    String vertexShader = "precision highp float;\nattribute vec4 position;\nattribute vec2 inputTextureCoordinate;\nuniform vec2 stepSize;\nuniform float Stride;\nvarying vec2 TexCoord1;\nvarying vec2 TexCoord2;\nvarying vec2 TexCoord3;\nvarying vec2 TexCoord4;\nvoid main(){ \n    TexCoord1 = inputTextureCoordinate;\n    TexCoord2 = inputTextureCoordinate + stepSize*Stride;\n    TexCoord3 = inputTextureCoordinate + stepSize*2.0*Stride;\n    TexCoord4 = inputTextureCoordinate + stepSize*3.0*Stride;\n    gl_Position = position;\n}";
    String shader = "precision highp float;\nuniform vec4 colorCoeff1;\nuniform vec4 colorCoeff2;\nuniform vec4 colorCoeff3;\nuniform vec4 colorCoeff4;\nvarying vec2 TexCoord1;\nvarying vec2 TexCoord2;\nvarying vec2 TexCoord3;\nvarying vec2 TexCoord4;\nuniform sampler2D inputImageTexture0;\nvoid main(){ \n    gl_FragColor = texture2D(inputImageTexture0, TexCoord1)*colorCoeff1 + texture2D(inputImageTexture0, TexCoord2)*colorCoeff2 + texture2D(inputImageTexture0, TexCoord3)*colorCoeff3 + texture2D(inputImageTexture0, TexCoord4)*colorCoeff4; \n}";

    @Override
    protected void initWithGLContext() {
        super.initWithGLContext();
        this.handlerStepSize = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_STEP_SIZE);
        this.handlerStride = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_STRIDE);
        this.handlerCoeff1 = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOR_COEFF1);
        this.handlerCoeff2 = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOR_COEFF2);
        this.handlerCoeff3 = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOR_COEFF3);
        this.handlerCoeff4 = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOR_COEFF4);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.handlerStride, (float)this.stride);
        GLES20.glUniform2f((int)this.handlerStepSize, (float)this.stepSize[0], (float)this.stepSize[1]);
        GLES20.glUniform4f((int)this.handlerCoeff1, (float)this.coeff1[0], (float)this.coeff1[1], (float)this.coeff1[2], (float)this.coeff1[3]);
        GLES20.glUniform4f((int)this.handlerCoeff2, (float)this.coeff2[0], (float)this.coeff2[1], (float)this.coeff2[2], (float)this.coeff2[3]);
        GLES20.glUniform4f((int)this.handlerCoeff3, (float)this.coeff3[0], (float)this.coeff3[1], (float)this.coeff3[2], (float)this.coeff3[3]);
        GLES20.glUniform4f((int)this.handlerCoeff4, (float)this.coeff4[0], (float)this.coeff4[1], (float)this.coeff4[2], (float)this.coeff4[3]);
    }

    public void setStride(float stride) {
        this.stride = stride;
    }

    public void setStepSize(float x, float y) {
        this.stepSize[0] = x;
        this.stepSize[1] = y;
    }

    public void setCoeff1(float x, float y, float z, float w) {
        this.coeff1[0] = x;
        this.coeff1[1] = y;
        this.coeff1[2] = z;
        this.coeff1[3] = w;
    }

    public void setCoeff2(float x, float y, float z, float w) {
        this.coeff2[0] = x;
        this.coeff2[1] = y;
        this.coeff2[2] = z;
        this.coeff2[3] = w;
    }

    public void setCoeff3(float x, float y, float z, float w) {
        this.coeff3[0] = x;
        this.coeff3[1] = y;
        this.coeff3[2] = z;
        this.coeff3[3] = w;
    }

    public void setCoeff4(float x, float y, float z, float w) {
        this.coeff4[0] = x;
        this.coeff4[1] = y;
        this.coeff4[2] = z;
        this.coeff4[3] = w;
    }

    @Override
    public String getVertexShader() {
        return this.vertexShader;
    }

    @Override
    protected String getFragmentShader() {
        return this.shader;
    }
}

