/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class ZoomFusionEffectFilter
extends MultiInputFilter
implements MoveFilterInterface {
    public static final String UNIFORM_SHIFT = "shift";
    public static final String UNIFORM_MIX_SHIFT = "mixShift";
    private int shiftHandler;
    private int mixShiftHandler;
    private float offset = 0.8f;
    private float mixOffset = 0.0f;
    private boolean mHasChanged = false;
    private int mFrameRate = 25;

    public ZoomFusionEffectFilter() {
        super(2);
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float shift;\n  uniform float mixShift;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    vec2 uv1 = scaleFromCenter(uv,shift);\n    vec3 color1 = texture2D(inputImageTexture1, uv1).rgb;\n    vec3 color2 = texture2D(inputImageTexture0, uv).rgb;\n    vec3 mixColor = mix(color1, color2, 1.0 -mixShift);\n    gl_FragColor = vec4(mixColor,1.0);\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
        this.mixShiftHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MIX_SHIFT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.mHasChanged) {
            this.offset += 0.4f / (float)this.mFrameRate;
            if ((double)this.offset >= 1.0) {
                this.offset = 1.0f;
            }
            this.mixOffset += 1.0f / (float)this.mFrameRate;
            if ((double)this.mixOffset >= 1.0) {
                this.mixOffset = 1.0f;
            }
        }
        GLES20.glUniform1f((int)this.shiftHandler, (float)this.offset);
        GLES20.glUniform1f((int)this.mixShiftHandler, (float)this.mixOffset);
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        this.offset = 0.8f;
        this.mixOffset = 0.0f;
    }

    @Override
    public void setFrameRate(int rate) {
        this.mFrameRate = rate;
    }
}

