/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class ZoomEffectFilter
extends MultiInputFilter
implements MoveFilterInterface {
    public static final String UNIFORM_SCALE = "scale";
    public static final String UNIFORM_MIX_RATIO = "ratio";
    public static final String UNIFORM_INIT_SCALE = "initScale";
    public static final String UNIFORM_SLOPE = "slope";
    public static final String UNIFORM_INTERCEPT = "intercept";
    public static final String UNIFORM_USETRANSFER = "useTransfer";
    public static final String UNIFORM_INDEX = "index";
    private int scaleHandler;
    private int mixRatioHandler;
    private int initScaleHandler;
    private int slopeHandler;
    private int interceptHandler;
    private int transferHandler;
    private int indexHandler;
    private boolean mHasChanged = false;
    private float mRatio = 0.0f;
    private float mShift = 0.5f;
    private float mScale = 0.0f;
    private float mScaleResult = 1.0f;
    private float mInitScale = 1.0f;
    private float mShiftStep = 0.0f;
    private float mScaleStep = 0.0f;
    private float mRatioStep = 0.0f;
    private float mVertexScale = 1.0f;
    public float[] texData0 = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private float mIntercept = -1.0f;
    private float mSlopeStep = 0.0f;
    private float mSlope = 0.0f;
    private boolean mUseTransfer = false;
    private float mIndex = 0.0f;
    private float mUseTrans = 0.0f;
    private float mScaleStepTemp;
    private float mShiftYStep = 0.0f;
    private float mShiftY = 0.5f;

    public ZoomEffectFilter() {
        super(2);
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float scale;\n  uniform float ratio;\n  uniform float initScale;\n  uniform float slope;\n  uniform float intercept;\n  uniform float useTransfer;\n  uniform float index;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    vec2 uv1 = scaleFromCenter(uv,scale);\n    vec3 color1 = texture2D(inputImageTexture1, uv1).rgb;\n    vec2 uv2 = scaleFromCenter(uv,initScale);\n    vec3 color2 = texture2D(inputImageTexture0, uv2).rgb;\n    vec3 mixColor = mix(color1, color2, 1.0 - ratio);\n    if (useTransfer == 1.0) {\n       if (index == 0.0) {\n          if (uv.x > slope * uv.y + intercept) {\n             gl_FragColor = vec4(mixColor,1.0);\n          } else {\n             gl_FragColor = vec4(1.0,1.0,1.0,1.0);\n          }\n       } else {\n          if (uv.x < slope * uv.y + intercept) {\n             gl_FragColor = vec4(mixColor,1.0);\n          } else {\n             gl_FragColor = vec4(1.0,1.0,1.0,1.0);\n          }\n       }\n    } else {\n      gl_FragColor = vec4(mixColor,1.0);\n    }\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.scaleHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SCALE);
        this.mixRatioHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_MIX_RATIO);
        this.initScaleHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INIT_SCALE);
        this.slopeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SLOPE);
        this.interceptHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INTERCEPT);
        this.transferHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_USETRANSFER);
        this.indexHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INDEX);
    }

    @Override
    protected void passShaderValues() {
        this.setAnimationProcess();
        super.passShaderValues();
        if (this.mHasChanged) {
            if (this.mScaleStep > 0.0f) {
                this.mScale += this.mScaleStep;
                if (this.mScale >= 1.0f) {
                    this.mScale = 1.0f;
                }
            } else {
                this.mScale = 1.0f + this.mScaleStep;
                this.mScaleStep += this.mScaleStepTemp;
                if (this.mScale <= this.mScaleResult) {
                    this.mScale = this.mScaleResult;
                }
            }
            this.mRatio += this.mRatioStep;
            if ((double)this.mRatio >= 1.0) {
                this.mRatio = 1.0f;
            }
            if (this.mUseTransfer) {
                if (this.mIndex == 0.0f && Math.abs(this.mScaleStep) >= 0.2f) {
                    this.mSlope = -(this.mSlopeStep += 1.0f);
                    this.mIntercept += 1.5f;
                    this.mUseTrans = 1.0f;
                } else if (this.mIndex == 1.0f) {
                    this.mSlope = -(this.mSlopeStep += 1.0f);
                    this.mIntercept += 1.3f;
                    this.mUseTrans = 1.0f;
                }
            }
        }
        GLES20.glUniform1f((int)this.scaleHandler, (float)this.mScale);
        GLES20.glUniform1f((int)this.mixRatioHandler, (float)this.mRatio);
        GLES20.glUniform1f((int)this.initScaleHandler, (float)this.mInitScale);
        GLES20.glUniform1f((int)this.slopeHandler, (float)this.mSlope);
        GLES20.glUniform1f((int)this.interceptHandler, (float)this.mIntercept);
        GLES20.glUniform1f((int)this.transferHandler, (float)this.mUseTrans);
        GLES20.glUniform1f((int)this.indexHandler, (float)this.mIndex);
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        this.mRatio = 0.0f;
        this.mShift = 0.5f;
        this.mScale = 0.0f;
        this.mInitScale = 1.0f;
        this.mShiftStep = 0.0f;
        this.mScaleStep = 0.0f;
        this.mRatioStep = 0.0f;
        this.mSlope = 0.0f;
        this.mIntercept = -1.0f;
        this.mSlopeStep = 0.0f;
        this.mUseTransfer = false;
        this.mIndex = 1.0f;
        this.mUseTrans = 0.0f;
        this.mScaleResult = 0.0f;
        this.mScaleStepTemp = 0.0f;
    }

    protected void setAnimationProcess() {
        this.mShift += this.mShiftStep;
        if (this.mShift >= 0.7f) {
            this.mShift = 0.7f;
        }
        this.mShiftY += this.mShiftYStep;
        if (this.mShiftY >= 0.6f) {
            this.mShiftY = 0.6f;
        }
        float[] fArray = this.setParamForMatrix(this.mVertexScale, this.mVertexScale, new PointF(this.mShift, this.mShiftY));
        this.setRenderVertices(fArray);
    }

    public float[] setParamForMatrix(float w, float h, PointF centerPoint) {
        if (centerPoint == null) {
            return null;
        }
        float f = w;
        float f2 = h;
        float f3 = -(centerPoint.x * 2.0f - 1.0f);
        float f4 = -centerPoint.y * 2.0f + 1.0f;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f3), (float)f4, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)(f * 1.0f), (float)(f2 * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[4], fArray2[5], fArray2[8], fArray2[9], fArray2[12], fArray2[13]};
        return fArray3;
    }

    @Override
    public void setFrameRate(int rate) {
    }

    public void setRatio(float mRatio) {
        this.mRatio = mRatio;
    }

    public void setShift(float mShift) {
        this.mShift = mShift;
    }

    public void setScale(float mScale) {
        this.mScaleResult = this.mScale = 1.0f + (1.0f - mScale);
    }

    public void setInitScale(float mInitScale) {
        this.mInitScale = 1.0f + (1.0f - mInitScale);
    }

    public void setShiftStep(float mShiftStep) {
        this.mShiftStep = mShiftStep;
    }

    public void setRatioStep(float mRatioStep) {
        this.mRatioStep = mRatioStep;
    }

    public void setScaleStep(float mScaleStep) {
        this.mScaleStepTemp = this.mScaleStep = mScaleStep;
    }

    public void setVertexScale(float mVertexScale) {
        this.mVertexScale = 1.0f + 2.0f * (mVertexScale - 1.0f);
    }

    public void setUseTransfer(boolean transfer, int index) {
        this.mUseTransfer = transfer;
        this.mIndex = index;
    }

    public void setShiftYStep(float mShiftStep) {
        this.mShiftYStep = mShiftStep;
    }

    public void setShiftY(float shift) {
        this.mShiftY = shift;
    }
}

