/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class VignetteFilter
extends BasicFilter {
    protected static final String UNIFORM_CENTER = "u_Center";
    protected static final String UNIFORM_COLOUR = "u_Colour";
    protected static final String UNIFORM_START = "u_Start";
    protected static final String UNIFORM_END = "u_End";
    private int centerHandle;
    private int colourHandle;
    private int startHandle;
    private int endHandle;
    private PointF center;
    private float[] colour;
    private float start;
    private float end;

    public VignetteFilter(PointF center, float[] colour, float start, float end) {
        this.center = center;
        this.colour = colour;
        this.start = start;
        this.end = end;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform vec2 u_Center;\nuniform vec3 u_Colour;\nuniform float u_Start;\nuniform float u_End;\nvoid main(){\n\tlowp vec4 color = texture2D(inputImageTexture0, textureCoordinate);\n \tmediump float d = distance(textureCoordinate, u_Center);\n \tlowp float percent = smoothstep(u_Start, u_End, d);\n \tgl_FragColor = vec4(mix(color.rgb, u_Colour, percent), color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.centerHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CENTER);
        this.colourHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLOUR);
        this.startHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_START);
        this.endHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_END);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.centerHandle, (float)this.center.x, (float)this.center.y);
        GLES20.glUniform3f((int)this.colourHandle, (float)this.colour[0], (float)this.colour[1], (float)this.colour[2]);
        GLES20.glUniform1f((int)this.startHandle, (float)this.start);
        GLES20.glUniform1f((int)this.endHandle, (float)this.end);
    }
}

