/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class TransferWhiteFilter
extends BasicFilter
implements IVideoTrackTime {
    public static final String UNIFORM_SCALE = "scale";
    public static final String UNIFORM_ALPHA = "alpha";
    public static final String UNIFORM_SLOPE = "slope";
    public static final String UNIFORM_INTERCEPT = "intercept";
    private int scaleHandler;
    private int alphaHandler;
    private int slopeHandler;
    private int interceptHandler;
    private float mShift = 0.5f;
    private float mScale = 0.0f;
    private float mScaleResult = 1.0f;
    private float mShiftStep = 0.0f;
    private float mScaleStep = 0.0f;
    private float mVertexScale = 1.0f;
    public float[] texData0 = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private float mAlpha = 1.0f;
    private float mAlphaStep = 0.0f;
    private float mSlope = 0.0f;
    private float mIntercept = -1.0f;
    private float mSlopeStep = 0.0f;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float scale;\n  uniform float alpha;\n  uniform float slope;\n  uniform float intercept;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    vec2 uv1 = scaleFromCenter(uv,scale);\n    if (uv.x < slope * uv.y + intercept) {\n       gl_FragColor = texture2D(inputImageTexture0, uv);\n    } else {\n       gl_FragColor = vec4(1.0,1.0,1.0,1.0);\n    }\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.scaleHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SCALE);
        this.alphaHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ALPHA);
        this.slopeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SLOPE);
        this.interceptHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_INTERCEPT);
    }

    @Override
    protected void passShaderValues() {
        this.setAnimationProcess();
        super.passShaderValues();
        this.mScaleResult += this.mScaleStep;
        if (this.mScaleStep < 0.0f) {
            if (this.mScaleResult <= this.mScale) {
                this.mScaleResult = this.mScale;
            }
        } else if (this.mScaleResult >= this.mScale) {
            this.mScaleResult = this.mScale;
        }
        this.mAlpha += this.mAlphaStep;
        if ((double)this.mAlpha >= 1.0) {
            this.mAlpha = 1.0f;
        }
        this.mSlope = -(this.mSlopeStep + 2.0f);
        this.mIntercept += 0.6f;
        GLES20.glUniform1f((int)this.scaleHandler, (float)this.mScaleResult);
        GLES20.glUniform1f((int)this.alphaHandler, (float)this.mAlpha);
        GLES20.glUniform1f((int)this.slopeHandler, (float)this.mSlope);
        GLES20.glUniform1f((int)this.interceptHandler, (float)this.mIntercept);
    }

    @Override
    public void drawSub() {
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        super.drawSub();
        GLES20.glDisable((int)3042);
    }

    public void resetInfo() {
        this.mShift = 0.5f;
        this.mScale = 0.0f;
        this.mScaleResult = 1.0f;
        this.mShiftStep = 0.0f;
        this.mScaleStep = 0.0f;
        this.mAlpha = 1.0f;
        this.mAlphaStep = 0.0f;
        this.mSlope = 0.0f;
        this.mIntercept = -1.0f;
        this.mSlopeStep = 0.0f;
    }

    protected void setAnimationProcess() {
        this.mShift += this.mShiftStep;
        if (this.mShift >= 0.7f) {
            this.mShift = 0.7f;
        }
        float[] fArray = this.setParamForMatrix(this.mVertexScale, this.mVertexScale, new PointF(this.mShift, 0.5f));
        this.setRenderVertices(fArray);
    }

    public float[] setParamForMatrix(float w, float h, PointF centerPoint) {
        if (centerPoint == null) {
            return null;
        }
        float f = w;
        float f2 = h;
        float f3 = -(centerPoint.x * 2.0f - 1.0f);
        float f4 = -centerPoint.y * 2.0f + 1.0f;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f3), (float)f4, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)(f * 1.0f), (float)(f2 * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[4], fArray2[5], fArray2[8], fArray2[9], fArray2[12], fArray2[13]};
        return fArray3;
    }

    public void setShift(float mShift) {
        this.mShift = mShift;
    }

    public void setScale(float mScale) {
        this.mScale = 1.0f + (1.0f - mScale);
    }

    public void setShiftStep(float mShiftStep) {
        this.mShiftStep = mShiftStep;
    }

    public void setScaleStep(float mScaleStep) {
        this.mScaleStep = mScaleStep;
    }

    public void setVertexScale(float mVertexScale) {
        this.mVertexScale = 1.0f + 2.0f * (mVertexScale - 1.0f);
    }

    public void setAlpha(float mAlpha) {
        this.mAlpha = mAlpha;
    }

    public void setAlphaStep(float mAlphaStep) {
        this.mAlphaStep = mAlphaStep;
    }

    @Override
    public void setTimeStamp(long ms) {
    }
}

