/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.effect.FilterTransUtils;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class TransferEffectProcessFilter
extends BasicFilter
implements MoveFilterInterface {
    public static final String UNIFORM_BAR = "barLength";
    private int barHandler;
    private boolean mHasChanged = true;
    private int mFrameRate = 25;
    private float[] mBarLength = new float[6];
    private FilterTransUtils filterTransUtils = new FilterTransUtils(0.0f, 1.0f, 1.0f);
    private float mFrameTime = 1.0f / (float)this.mFrameRate;
    private float mTotalTime = 0.0f;
    private float mBarLength1 = 0.0f;
    private float mBarLength2 = 0.0f;
    private float mBarLength3 = 0.0f;
    private float mBarLength4 = 0.0f;
    private float mBarLength5 = 0.0f;
    private float mBarLength6 = 0.0f;

    @Override
    protected String getFragmentShader() {
        String string = "precision lowp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n\nconst float barWidth = 1.0 / 6.0;\n\nuniform float barLength[6];\n\nvoid main() {\n    int bar = int((1.0 - textureCoordinate.y) / barWidth);\n    \n    vec4 color;\n    if (textureCoordinate.x < barLength[bar]) {\n        color = vec4(1.0);\n    } else {\n        color = texture2D(inputImageTexture0, textureCoordinate);\n    }\n    gl_FragColor = color;\n}";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.barHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BAR);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.mHasChanged) {
            this.mTotalTime += this.mFrameTime;
            if (this.mTotalTime > 2.5f) {
                float f;
                float f2 = this.mTotalTime - 2.5f;
                if (this.mBarLength1 < 1.0f) {
                    f = f2 > 0.36f ? 0.36f : f2;
                    this.filterTransUtils.setDuration(0.36f);
                    this.mBarLength1 = this.filterTransUtils.evaluateAtTimeInOut(f);
                    float f3 = this.mBarLength[0] = this.mBarLength1 <= 1.0f ? this.mBarLength1 : 1.0f;
                }
                if (f2 > 0.12f && this.mBarLength2 < 1.0f) {
                    f = f2 - 0.12f > 0.56f ? 0.56f : f2 - 0.12f;
                    this.filterTransUtils.setDuration(0.56f);
                    this.mBarLength2 = this.filterTransUtils.evaluateAtTimeInOut(f);
                    float f4 = this.mBarLength[1] = this.mBarLength2 <= 1.0f ? this.mBarLength2 : 1.0f;
                }
                if (f2 > 0.3f && this.mBarLength3 < 1.0f) {
                    f = f2 - 0.3f > 0.3f ? 0.3f : f2 - 0.3f;
                    this.filterTransUtils.setDuration(0.3f);
                    this.mBarLength3 = this.filterTransUtils.evaluateAtTimeInOut(f);
                    float f5 = this.mBarLength[2] = this.mBarLength3 <= 1.0f ? this.mBarLength3 : 1.0f;
                }
                if (f2 > 0.2f && this.mBarLength4 < 1.0f) {
                    f = f2 - 0.2f > 0.4f ? 0.4f : f2 - 0.2f;
                    this.filterTransUtils.setDuration(0.4f);
                    this.mBarLength4 = this.filterTransUtils.evaluateAtTimeInOut(f);
                    float f6 = this.mBarLength[3] = this.mBarLength4 <= 1.0f ? this.mBarLength4 : 1.0f;
                }
                if (f2 > 0.12f && this.mBarLength5 < 1.0f) {
                    f = f2 - 0.12f > 0.16f ? 0.16f : f2 - 0.12f;
                    this.filterTransUtils.setDuration(0.16f);
                    this.mBarLength5 = this.filterTransUtils.evaluateAtTimeInOut(f);
                    float f7 = this.mBarLength[4] = this.mBarLength5 <= 1.0f ? this.mBarLength5 : 1.0f;
                }
                if (f2 > 0.42f && this.mBarLength6 < 1.0f) {
                    f = f2 - 0.42f > 0.2f ? 0.2f : f2 - 0.42f;
                    this.filterTransUtils.setDuration(0.2f);
                    this.mBarLength6 = this.filterTransUtils.evaluateAtTimeInOut(f);
                    this.mBarLength[5] = this.mBarLength6 <= 1.0f ? this.mBarLength6 : 1.0f;
                }
            }
        }
        GLES20.glUniform1fv((int)this.barHandler, (int)6, (float[])this.mBarLength, (int)0);
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        for (int i = 0; i < this.mBarLength.length; ++i) {
            this.mBarLength[i] = 0.0f;
        }
    }

    @Override
    public void setFrameRate(int rate) {
        this.mFrameRate = rate;
        this.mFrameTime = 1.0f / (float)this.mFrameRate;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mHasChanged = false;
    }

    public synchronized void startAnimation() {
        this.mHasChanged = true;
        for (int i = 0; i < this.mBarLength.length; ++i) {
            this.mBarLength[i] = 0.0f;
        }
    }
}

