/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class TopShiftFilter
extends BasicFilter
implements MoveFilterInterface {
    public static final String UNIFORM_SHIFT = "shift";
    private int shiftHandler;
    private float offset = 0.0f;
    private boolean mHasChanged = true;
    private int mFrameRate = 25;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float shift;\nvoid main(){\n    vec2 uv = textureCoordinate;\n    if (uv.y >= 1.0 - shift){\n       vec2 uv1 = vec2(uv.x,uv.y - 1.0 + shift);\n       gl_FragColor = texture2D(inputImageTexture0, uv1);\n    }}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.mHasChanged && this.offset < 1.0f) {
            this.offset += 0.5f / (float)this.mFrameRate;
            if ((double)this.offset >= 1.0) {
                this.offset = 1.0f;
            }
        }
        GLES20.glUniform1f((int)this.shiftHandler, (float)this.offset);
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        this.offset = 0.0f;
    }

    @Override
    public void setFrameRate(int rate) {
        this.mFrameRate = rate;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.offset = 0.0f;
        this.mHasChanged = false;
    }

    public synchronized void startAnimation() {
        this.mHasChanged = true;
        this.offset = 0.0f;
    }
}

