/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ThreeStateInFilter
extends BasicFilter
implements IVideoTrackTime {
    protected static final String UNIFORM_SHIFT = "shift";
    private int shiftHandle;
    private float shift = 0.0f;
    private boolean hasChanged = false;
    private long lastFrameTime = -1L;
    private long currentTime = -1L;

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float shift;\nvoid main(){\n vec2 uv = textureCoordinate ;\n     \n     if (uv.y < 1.0 / 3.0 || uv.y > 2.0 / 3.0) {\n         if (uv.x < shift) {\n             vec2 uv1 = vec2(uv.x + 1.0 - shift, uv.y);\n             gl_FragColor = texture2D(inputImageTexture0, uv1);\n         } else {\n             gl_FragColor = vec4(vec3(0.0), 1.0);\n         }\n     } else {\n         gl_FragColor = texture2D(inputImageTexture0, uv);\n     }}\n";
    }

    public synchronized void startAnimation() {
        this.lastFrameTime = -1L;
        this.hasChanged = true;
        this.shift = 0.0f;
    }

    public synchronized void endProcessing() {
        this.hasChanged = false;
        this.shift = 0.0f;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        super.newTextureReady(texture, source, newData);
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = this.currentTime;
            return;
        }
        if (this.hasChanged) {
            long l = this.currentTime - this.lastFrameTime;
            this.shift += (float)l / 1000.0f;
            if (this.shift >= 1.0f) {
                this.shift = 1.0f;
                this.hasChanged = false;
            }
            this.lastFrameTime = l + this.lastFrameTime;
        }
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.shiftHandle, (float)this.shift);
    }

    @Override
    public void setTimeStamp(long ms) {
        this.currentTime = ms;
    }
}

