/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ThreeStateEnterFilter
extends BasicFilter
implements IVideoTrackTime {
    protected static final String UNIFORM_SHIFT = "shift";
    private int shiftHandle;
    private float shift = 2.0f;
    private boolean hasChanged = false;
    private long lastFrameTime = -1L;
    private long mCurrentTime = -1L;

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float shift;\nvoid main(){\nvec2 uv = textureCoordinate;\n     \n     if (shift == 0.0) {\n         if (uv.y < 1.0 / 3.0) {\n             gl_FragColor = texture2D(inputImageTexture0, uv);\n         } else {\n             gl_FragColor = vec4(vec3(1.0), 1.0);\n         }\n     } else if (shift == 1.0) {\n         if (uv.y > 1.0 / 3.0 && uv.y < 2.0 / 3.0) {\n             gl_FragColor = texture2D(inputImageTexture0, uv);\n         } else {\n             gl_FragColor = vec4(vec3(1.0), 1.0);\n         }\n     } else if (shift == 2.0) {\n         if (uv.y > 2.0 / 3.0) {\n             gl_FragColor = texture2D(inputImageTexture0, uv);\n         } else {\n             gl_FragColor = vec4(vec3(1.0), 1.0);\n         }\n     } else {\n         gl_FragColor = texture2D(inputImageTexture0, uv);\n     } }\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.shiftHandle, (float)this.shift);
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        long l = System.currentTimeMillis();
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = this.mCurrentTime;
        }
        if (this.hasChanged) {
            long l2 = this.mCurrentTime - this.lastFrameTime;
            this.shift = l2 < 700L ? 2.0f : (l2 < 1400L ? 1.0f : (l2 < 2100L ? 0.0f : -1.0f));
        }
        super.newTextureReady(texture, source, newData);
    }

    public void setShift(float shift) {
        this.shift = shift;
    }

    public synchronized void startAnimation() {
        this.lastFrameTime = -1L;
        this.hasChanged = true;
        this.shift = 0.0f;
    }

    @Override
    public void setTimeStamp(long ms) {
        this.mCurrentTime = ms;
    }
}

