/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import java.io.File;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.ImageColorChangingFilter;
import project.android.imageprocessing.filter.effect.DownwardFilter;
import project.android.imageprocessing.filter.effect.FrameAdpterBlurFilter;
import project.android.imageprocessing.filter.effect.ImageScaleFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ThreeGradualEffectFilter
extends GroupFilter
implements IVideoTrackTime {
    private FrameAdpterBlurFilter frameAdaptFilterBefore = new FrameAdpterBlurFilter();
    private FrameAdpterBlurFilter frameAdaptFilterAfter = new FrameAdpterBlurFilter();
    private ImageScaleFilter imageScaleFilter;
    private ImageColorChangingFilter imageColorChangingFilter;
    private DownwardFilter downwardFilter = new DownwardFilter();
    private boolean hasChanged = false;
    private long lastFrameTime = -1L;
    private long currentTime = -1L;
    private float offset = 0.0f;
    private float mixture = 0.0f;
    private final float timeMargin = 600.0f;
    private final float offsetMargin = 0.333f;
    private String lookupPath;
    private boolean noBitmap = true;
    private Bitmap lookup;

    public ThreeGradualEffectFilter() {
        this.imageColorChangingFilter = new ImageColorChangingFilter();
        this.imageScaleFilter = new ImageScaleFilter();
        this.frameAdaptFilterBefore.addTarget(this.imageScaleFilter);
        this.imageScaleFilter.addTarget(this.imageColorChangingFilter);
        this.imageColorChangingFilter.addTarget(this.downwardFilter);
        this.frameAdaptFilterAfter.addTarget(this.downwardFilter);
        this.downwardFilter.registerFilterLocation(this.imageColorChangingFilter, 0);
        this.downwardFilter.registerFilterLocation(this.frameAdaptFilterAfter, 1);
        this.downwardFilter.addTarget(this);
        this.downwardFilter.setMixture(0.2f);
        this.imageScaleFilter.setScale(0.9259259f);
        this.registerInitialFilter(this.frameAdaptFilterBefore);
        this.registerInitialFilter(this.frameAdaptFilterAfter);
        this.registerTerminalFilter(this.downwardFilter);
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.lookup != null && !this.lookup.isRecycled()) {
            this.lookup.recycle();
            this.lookup = null;
        }
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.lookup != null && this.noBitmap) {
            this.imageColorChangingFilter.setLookupBitmap(this.lookup);
            this.imageColorChangingFilter.setIntensity(1.0f);
            this.noBitmap = false;
        }
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = this.currentTime;
        }
        if (this.hasChanged) {
            long l = this.currentTime - this.lastFrameTime;
            this.offset = l < 1500L ? (float)l / 1500.0f : 1.0f;
            this.mixture = l < 200L ? 0.2f : (float)(l - 200L) / 1500.0f + 0.2f;
            if (this.mixture > 1.0f) {
                this.mixture = 1.0f;
            }
            this.downwardFilter.setOffset(this.offset);
            this.downwardFilter.setMixture(this.mixture);
        }
        super.newTextureReady(texture, source, newData);
    }

    public void setTransferFieldImage(Bitmap bitmapBefore, Bitmap bitmapAfter) {
        if (this.frameAdaptFilterBefore != null && this.frameAdaptFilterAfter != null) {
            this.frameAdaptFilterBefore.setImageInfo(bitmapBefore);
            this.frameAdaptFilterAfter.setImageInfo(bitmapAfter);
        }
        this.startAnimation();
    }

    private synchronized void startAnimation() {
        this.lastFrameTime = -1L;
        this.hasChanged = true;
        this.downwardFilter.setOffset(this.offset);
        this.downwardFilter.setMixture(0.2f);
        this.downwardFilter.setOffset(0.0f);
    }

    @Override
    public void setTimeStamp(long ms) {
        this.currentTime = ms;
    }

    private boolean exist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return new File(path).exists();
    }

    public synchronized void setLookupPath(String path) {
        this.lookupPath = path + "/lookup3.jpg";
        if (this.exist(this.lookupPath)) {
            this.lookup = BitmapFactory.decodeFile((String)this.lookupPath);
        }
    }
}

