/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicEffectFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class TVArtifactFilter
extends BasicEffectFilter
implements IVideoTrackTime {
    public static final String UNIFORM_COLORIZATION = "colorization";
    public static final String UNIFORM_NOISE = "noise";
    public static final String UNIFORM_PARASITE = "parasite";
    public static final String UNIFORM_FADE = "fade";
    public static final String UNIFORM_TIME = "time";
    private int colorizationHandler;
    private int noiseHandler;
    private int parasiteHandler;
    private int fadeHandler;
    private int timeHandler;
    private float colorization = 1.0f;
    private float noise = 1.0f;
    private float parasite = 1.0f;
    private float fade = 1.0f;
    private float time = 0.0f;
    private long duration = 100000L;

    public TVArtifactFilter() {
        this.mFilterId = 4;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.colorizationHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_COLORIZATION);
        this.noiseHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_NOISE);
        this.parasiteHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_PARASITE);
        this.fadeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_FADE);
        this.timeHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TIME);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.colorizationHandler, (float)this.colorization);
        GLES20.glUniform1f((int)this.noiseHandler, (float)this.noise);
        GLES20.glUniform1f((int)this.parasiteHandler, (float)this.parasite);
        GLES20.glUniform1f((int)this.fadeHandler, (float)this.fade);
        GLES20.glUniform1f((int)this.timeHandler, (float)this.time);
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform float colorization;\nuniform float noise;\nuniform float parasite;\nuniform float fade;\nuniform float time;\nvarying vec2 textureCoordinate;\nfloat rng2(vec2 seed, float time)\n{\n    return fract(sin(dot(seed * floor(time * 12.0), vec2(12.9898,78.233))) * 43758.5453123);\n}\nfloat rng(float seed, float time)\n{\n    return rng2(vec2(seed, 1.0), time);\n}\nvoid main(){\n   vec2 uv = textureCoordinate;\n   vec2 blockS = floor(uv * vec2(24.0,9.0));\n   vec2 blockL = floor(uv * vec2(8.0,4.0));\n   float r = rng2(uv,time);\n   vec3 noise_ = (vec3(r, 1. - r * colorization, r / 2.0 + 0.5) * 1.0 * noise - 2.0) * 0.08;\n   float lineNoise = pow(rng2(blockS, time), 8.0) * parasite * pow(rng2(blockL, time), 3.0) - pow(rng(7.2341, time), 17.0) * 2.0;\n   vec4 col1 = texture2D(inputImageTexture0,uv).rgba;\n   vec4 col2 = texture2D(inputImageTexture0,uv + vec2(lineNoise * 0.05 * rng(5.0, time), 0)).rgba;\n   vec4 col3 = texture2D(inputImageTexture0,uv - vec2(lineNoise * 0.05 * rng(31.0, time), 0)).rgba;\n   vec4 result = vec4(vec3(col1.x, col2.y, col3.z) + noise_, 1.0);\n   result = mix(col1,result,fade);\n   gl_FragColor = result;\n}\n";
        return string;
    }

    public void setColorization(float colorization) {
        this.colorization = colorization;
    }

    public void setNoise(float noise) {
        this.noise = noise;
    }

    public void setParasite(float parasite) {
        this.parasite = parasite;
    }

    public void setFade(float fade) {
        this.fade = fade;
    }

    @Override
    public void setTimeStamp(long ms) {
        super.setTimeStamp(ms);
        this.time = (float)ms / 1200.0f;
    }
}

