/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class SwirlFilter
extends BasicFilter {
    protected static final String UNIFORM_CENTER = "u_Center";
    protected static final String UNIFORM_RADIUS = "u_Radius";
    protected static final String UNIFORM_ANGLE = "u_Angle";
    private int centerHandle;
    private int radiusHandle;
    private int angleHandle;
    private float radius;
    private PointF center;
    private float angle;

    public SwirlFilter(PointF center, float radius, float angle) {
        this.center = center;
        this.radius = radius;
        this.angle = angle;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform vec2 u_Center;\nuniform float u_Radius;\nuniform float u_Angle;\nvoid main(){\n   highp vec2 textureCoordinateToUse = textureCoordinate;\n   highp float dist = distance(u_Center, textureCoordinate);\n   if (dist < u_Radius) {\n     textureCoordinateToUse -= u_Center;\n     highp float percent = (u_Radius - dist) / u_Radius;\n     highp float theta = percent * percent * u_Angle * 8.0;\n\t   highp float s = sin(theta);\n     highp float c = cos(theta);\n     textureCoordinateToUse = vec2(dot(textureCoordinateToUse, vec2(c, -s)), dot(textureCoordinateToUse, vec2(s, c)));\n     textureCoordinateToUse += u_Center;\n   }\n   gl_FragColor =  texture2D(inputImageTexture0, textureCoordinateToUse);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.centerHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CENTER);
        this.radiusHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_RADIUS);
        this.angleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ANGLE);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.centerHandle, (float)this.center.x, (float)this.center.y);
        GLES20.glUniform1f((int)this.radiusHandle, (float)this.radius);
        GLES20.glUniform1f((int)this.angleHandle, (float)this.angle);
    }
}

