/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class SpreadOutFilter
extends BasicFilter {
    private static final String UNIFORM_RANGE = "range";
    private int rangeHandle;
    protected float mFrameTime = 0.04f;
    protected float mTotalTime = 0.0f;
    private float mRangeValue = 0.5f;
    private float mRangeStep = 0.0f;
    private float mStartTime = 0.0f;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n  uniform float range;\nvoid main(){\n    vec2 uv = textureCoordinate;\n    if (uv.x > range && uv.x < 1.0 - range) {\n        gl_FragColor = texture2D(inputImageTexture0,uv);\n    } else {    }\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.rangeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_RANGE);
    }

    @Override
    protected void passShaderValues() {
        this.mTotalTime += this.mFrameTime;
        super.passShaderValues();
        if (this.mTotalTime >= this.mStartTime) {
            this.mRangeValue -= this.mRangeStep;
            if (this.mRangeValue < 0.0f) {
                this.mRangeValue = 0.0f;
            }
        }
        GLES20.glUniform1f((int)this.rangeHandle, (float)this.mRangeValue);
    }

    public void setStartTime(float startTime) {
        this.mStartTime = startTime;
    }

    public void setRangeStep(float rangeStep) {
        this.mRangeStep = rangeStep;
    }

    public synchronized void startAnimation() {
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mRangeValue = 0.5f;
        this.mRangeStep = 0.0f;
        this.mStartTime = 0.0f;
    }
}

