/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;

public class SketchEffectFilter
extends AbsEffectOptionFilter {
    protected static final String UNIFORM_TEXELWIDTH = "u_TexelWidth";
    protected static final String UNIFORM_TEXELHEIGHT = "u_TexelHeight";
    protected float texelWidth;
    protected float texelHeight;
    private int texelWidthHandle;
    private int texelHeightHandle;

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_TexelWidth;\nuniform float u_TexelHeight;\nvoid main(){\n   vec2 up = vec2(0.0, u_TexelHeight);\n   vec2 right = vec2(u_TexelWidth, 0.0);\n   float bottomLeftIntensity = texture2D(inputImageTexture0, textureCoordinate - up - right).r;\n   float topRightIntensity = texture2D(inputImageTexture0, textureCoordinate + up + right).r;\n   float topLeftIntensity = texture2D(inputImageTexture0, textureCoordinate + up - right).r;\n   float bottomRightIntensity = texture2D(inputImageTexture0, textureCoordinate - up + right).r;\n   float leftIntensity = texture2D(inputImageTexture0, textureCoordinate - right).r;\n   float rightIntensity = texture2D(inputImageTexture0, textureCoordinate + right).r;\n   float bottomIntensity = texture2D(inputImageTexture0, textureCoordinate - up).r;\n   float topIntensity = texture2D(inputImageTexture0, textureCoordinate + up).r;\n   float h = -topLeftIntensity - 2.0 * topIntensity - topRightIntensity + bottomLeftIntensity + 2.0 * bottomIntensity + bottomRightIntensity;\n   float v = -bottomLeftIntensity - 2.0 * leftIntensity - topLeftIntensity + bottomRightIntensity + 2.0 * rightIntensity + topRightIntensity;\n   float mag = 1.0 - length(vec2(h, v));\n   gl_FragColor = vec4(vec3(mag), 1.0);\n}\n";
    }

    @Override
    protected void handleSizeChange() {
        super.handleSizeChange();
        this.texelWidth = 1.0f / (float)this.getWidth();
        this.texelHeight = 1.0f / (float)this.getHeight();
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.texelWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELWIDTH);
        this.texelHeightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_TEXELHEIGHT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.texelWidthHandle, (float)this.texelWidth);
        GLES20.glUniform1f((int)this.texelHeightHandle, (float)this.texelHeight);
    }
}

