/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class RightToLeftFilter
extends MultiInputFilter
implements MoveFilterInterface {
    public static final String UNIFORM_SHIFT = "shift";
    private int shiftHandler;
    private float offset = 0.0f;
    private boolean mHasChanged = false;
    private int mFrameRate = 25;

    public RightToLeftFilter() {
        super(2);
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float shift;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    if (uv.x >= 1. - shift){\n    vec2 uv1 = vec2(uv.x- (1.- shift),uv.y);\n       gl_FragColor = texture2D(inputImageTexture1, uv1);\n    } else {\n        vec2 uv2 = scaleFromCenter(uv,1.0 + .2*shift);\n        if (uv.x > 0.2 * shift *0.5 && uv.x < 1.0 - 0.2 * shift *0.5\n           && uv.y > 0.2 * shift *0.5 && uv.y < 1.0 - 0.2 * shift*0.5) {\n           gl_FragColor = texture2D(inputImageTexture0, uv2)*(1.0 -  shift);\n        }\n    }\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.mHasChanged) {
            this.offset += 2.0f / (float)this.mFrameRate;
            if ((double)this.offset >= 1.0) {
                this.offset = 1.0f;
                this.mHasChanged = false;
            }
        }
        GLES20.glUniform1f((int)this.shiftHandler, (float)this.offset);
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        this.offset = 0.0f;
    }

    @Override
    public void setFrameRate(int rate) {
        this.mFrameRate = rate;
    }
}

