/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class PosterizeFilter
extends BasicFilter {
    private static final String UNIFORM_QUANTIZATION = "u_Quantization";
    private int quantizationLevelsHandle;
    private float quantizationLevels;

    public PosterizeFilter(float quantizationLevels) {
        this.quantizationLevels = quantizationLevels;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_Quantization;\nvoid main(){\n   vec4 color = texture2D(inputImageTexture0, textureCoordinate);\n   vec3 posterizedImageColor = floor((color.rgb * u_Quantization) + 0.5) / u_Quantization;\n   gl_FragColor = vec4(posterizedImageColor, color.a);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.quantizationLevelsHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_QUANTIZATION);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.quantizationLevelsHandle, (float)this.quantizationLevels);
    }
}

