/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class PostWatermarkFilter
extends BasicFilter {
    public static final String ATTRIBUTE_MVP_MATRIX = "uMVPMatrix";
    public static final String ATTRIBUTE_DECORATION_SIZE = "decorationSize";
    public static final String ATTRIBUTE_POSITION_2 = "position2";
    public static final String UNIFORM_ALPHA = "alpha";
    protected final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    protected static final int COORDS_PER_VERTEX = 2;
    protected final int vertexStride = 8;
    protected int decorateHandler;
    protected int positionHandle2;
    protected int alphaHandle;
    public ShortBuffer drawListBuffer;
    protected final float[] mProjectionMatrix = new float[16];
    protected FloatBuffer vertexBufer;
    protected float[] textureCoord;
    private Bitmap mBitmap;
    public FloatBuffer vertexBuffer;
    public FloatBuffer fvertexBuffer;
    public float[] texData0;
    public final float[] mViewMatrix = new float[16];
    public float mBitmapScale;
    public List<float[]> mvpLists = Collections.synchronizedList(new ArrayList());
    public Object maskLock = new Object();
    public int mBitmap_textureID = -1;
    private boolean mBitmapChanged = false;
    private float mDimHeight = 640.0f;
    private float mCenterPointX = 0.5f;
    private float mCenterPointY = 0.5f;
    private float mAlpha = 1.0f;
    private float mFrameTime = 0.04f;
    private float mTotalTime = 0.0f;
    private float mAlphaTime = 0.0f;
    private float mAlphaStep = 0.0f;
    private float mCenterPointXStep = 0.0f;
    private float mCenterPointYStep = 0.0f;
    private float mShiftTime = 0.0f;
    private float mInitCenterX = 0.5f;
    private float mInitCenterY = 0.5f;
    private float mStartTime = 0.0f;
    private final String vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    private final String fragmentShaderCode = "precision mediump float;uniform sampler2D inputImageTexture0;varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform float alpha;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\n   gl_FragColor = vec4(color1.rgb,color1.a * alpha);\n}";

    public PostWatermarkFilter() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.drawOrder.length * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.drawListBuffer = byteBuffer.asShortBuffer();
        this.drawListBuffer.put(this.drawOrder);
        this.drawListBuffer.position(0);
        this.setBackgroundColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void initCoordinate() {
        if (this.mBitmap == null) {
            return;
        }
        float f = 0.5f;
        this.mBitmapScale = (float)this.mBitmap.getHeight() / (float)this.mBitmap.getWidth();
        float[] fArray = new float[]{-f, f * this.mBitmapScale, -f, -f * this.mBitmapScale, f, -f * this.mBitmapScale, f, f * this.mBitmapScale};
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = byteBuffer.asFloatBuffer();
        this.vertexBuffer.put(fArray);
        this.vertexBuffer.position(0);
        this.texData0 = new float[]{-f, f * this.mBitmapScale, 0.0f, 1.0f, -f, -f * this.mBitmapScale, 0.0f, 1.0f, f, -f * this.mBitmapScale, 0.0f, 1.0f, f, f * this.mBitmapScale, 0.0f, 1.0f};
        Matrix.setIdentityM((float[])this.mViewMatrix, (int)0);
        this.mViewMatrix[0] = -1.0f;
    }

    protected void passStickerShaderValues(float[] mvpMatrix) {
        if (this.mTotalTime >= this.mAlphaTime) {
            this.mAlpha += this.mAlphaStep;
            if (this.mAlpha >= 1.0f) {
                this.mAlpha = 1.0f;
            }
        }
        if (this.fvertexBuffer == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(mvpMatrix.length * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.fvertexBuffer = byteBuffer.asFloatBuffer();
        }
        this.fvertexBuffer.position(0);
        this.fvertexBuffer.put(mvpMatrix);
        this.fvertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.fvertexBuffer);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mBitmap_textureID);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1f((int)this.alphaHandle, (float)this.mAlpha);
    }

    public void drawStick(float aspectRatio) {
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)aspectRatio);
        GLES20.glDrawElements((int)4, (int)this.drawOrder.length, (int)5123, (Buffer)this.drawListBuffer);
        GLES20.glDisableVertexAttribArray((int)this.positionHandle);
    }

    public void drawBackgroundImage() {
        this.renderVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle);
        GLES20.glUniform2f((int)this.decorateHandler, (float)1.0f, (float)1.0f);
        if (this.textureCoord == null) {
            this.textureCoord = new float[8];
        }
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(this.textureCoord);
        if (this.vertexBufer == null) {
            this.vertexBufer = ByteBuffer.allocateDirect(this.textureCoord.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        for (int i = 0; i < 8; ++i) {
            this.textureCoord[i] = this.textureCoord[i] * -1.0f + 0.5f;
        }
        this.vertexBufer.position(0);
        this.vertexBufer.put(this.textureCoord);
        this.vertexBufer.position(0);
        GLES20.glVertexAttribPointer((int)this.positionHandle2, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexBufer);
        GLES20.glEnableVertexAttribArray((int)this.positionHandle2);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        GLES20.glUniform1f((int)this.alphaHandle, (float)1.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    @Override
    public void drawSub() {
        this.mTotalTime += this.mFrameTime;
        GLES20.glViewport((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight());
        GLES20.glUseProgram((int)this.programHandle);
        GLES20.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        GLES20.glClear((int)16640);
        this.drawBackgroundImage();
        if (this.mTotalTime > this.mStartTime && this.mBitmap != null) {
            GLES20.glEnable((int)3042);
            GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            this.processDisPlayInfo();
            if (this.mBitmap_textureID == -1 || this.mBitmapChanged) {
                this.mBitmap_textureID = this.bitmapToTexture(this.mBitmap);
                this.mBitmapChanged = false;
            }
            for (float[] fArray : this.mvpLists) {
                this.passStickerShaderValues(fArray);
                this.drawStick(this.getBitmapAspectRatio());
            }
            this.clearPoints();
            GLES20.glDisable((int)3042);
        }
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.positionHandle2 = GLES20.glGetAttribLocation((int)this.programHandle, (String)ATTRIBUTE_POSITION_2);
        this.decorateHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)ATTRIBUTE_DECORATION_SIZE);
        this.alphaHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ALPHA);
    }

    @Override
    protected void bindShaderAttributes() {
        super.bindShaderAttributes();
        GLES20.glBindAttribLocation((int)this.programHandle, (int)2, (String)ATTRIBUTE_MVP_MATRIX);
        GLES20.glBindAttribLocation((int)this.programHandle, (int)3, (String)ATTRIBUTE_DECORATION_SIZE);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        this.texture_in = texture;
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    @Override
    protected void handleSizeChange() {
        super.handleSizeChange();
        if (this.getHeight() > 0 && this.getWidth() > 0) {
            float f = (float)this.getWidth() / (float)this.getHeight();
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)(-1.0f / f), (float)(1.0f / f), (float)3.0f, (float)7.0f);
        }
    }

    @Override
    protected String getVertexShader() {
        return "uniform mat4 uMVPMatrix;attribute vec4 position;\nattribute vec4   position2 ; varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform vec2 decorationSize;\nvoid main() {  gl_Position = position;  vec2 coord = position2.xy;  coord = (coord) / decorationSize;\n  textureCoordinate = vec2(1.0 - (coord.x + 0.5),1.0-(coord.y + 0.5));\n}";
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;uniform sampler2D inputImageTexture0;varying vec2 textureCoordinate;\nvarying vec2 textureCoordinate1;\nuniform float alpha;\nvoid main() {   vec4 color1  = texture2D(inputImageTexture0,textureCoordinate);\n   gl_FragColor = vec4(color1.rgb,color1.a * alpha);\n}";
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.mBitmap_textureID != 0) {
            int[] nArray = new int[]{this.mBitmap_textureID};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mBitmap_textureID = 0;
        }
        if (this.mBitmap != null) {
            this.mBitmap = null;
        }
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.mBitmap_textureID != 0) {
            int[] nArray = new int[]{this.mBitmap_textureID};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mBitmap_textureID = 0;
        }
        if (this.mBitmap != null) {
            this.mBitmap = null;
        }
    }

    public void setParamForMatrix(float w, float h, PointF centerPoint, float angle) {
        if (centerPoint == null) {
            return;
        }
        float f = w;
        float f2 = h;
        float f3 = -(centerPoint.x * 2.0f - 1.0f);
        float f4 = -centerPoint.y * 2.0f + 1.0f;
        float f5 = angle;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f3), (float)f4, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])this.mViewMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.rotateM((float[])fArray, (int)0, (float)f5, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix.scaleM((float[])fArray, (int)0, (float)(f * 1.0f), (float)(f2 * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[4], fArray2[5], fArray2[8], fArray2[9], fArray2[12], fArray2[13]};
        this.mvpLists.add(fArray3);
    }

    private void processDisPlayInfo() {
        float f = (float)this.mBitmap.getWidth() * ((float)this.getHeight() * 1.0f / this.mDimHeight) / ((float)this.getWidth() / 2.0f);
        if (this.mTotalTime > this.mShiftTime) {
            this.mInitCenterX += this.mCenterPointXStep;
            if (this.mCenterPointXStep >= 0.0f) {
                if (this.mInitCenterX > this.mCenterPointX) {
                    this.mInitCenterX = this.mCenterPointX;
                }
            } else if (this.mInitCenterX < this.mCenterPointX) {
                this.mInitCenterX = this.mCenterPointX;
            }
            this.mInitCenterY += this.mCenterPointYStep;
            if (this.mCenterPointYStep >= 0.0f) {
                if (this.mInitCenterY > this.mCenterPointY) {
                    this.mInitCenterY = this.mCenterPointY;
                }
            } else if (this.mInitCenterY < this.mCenterPointY) {
                this.mInitCenterY = this.mCenterPointY;
            }
        }
        float f2 = this.mInitCenterX;
        if (this.mInitCenterX > 0.5f) {
            f2 = this.mInitCenterX - (float)this.mBitmap.getWidth() / (float)this.getWidth();
        }
        if (this.mInitCenterX < 0.5f) {
            f2 = this.mInitCenterX + (float)this.mBitmap.getWidth() / (float)this.getWidth();
        }
        PointF pointF = new PointF(f2, this.mInitCenterY);
        float f3 = f * 0.8f;
        float f4 = f * 0.8f;
        float f5 = 0.0f;
        this.setParamForMatrix(f3, f4, pointF, f5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPoints() {
        Object object = this.maskLock;
        synchronized (object) {
            if (this.mvpLists != null) {
                this.mvpLists.clear();
            }
        }
    }

    public void setPostBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mBitmapChanged = true;
        this.initCoordinate();
    }

    public int bitmapToTexture(Bitmap bitmap) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        return nArray[0];
    }

    public float getBitmapAspectRatio() {
        if (this.mBitmap != null) {
            return (float)this.mBitmap.getHeight() * 1.0f / (float)this.mBitmap.getWidth();
        }
        return 1.0f;
    }

    public void setDimHeight(float dimHeight) {
        this.mDimHeight = dimHeight;
    }

    public void setCenterInfo(float centerX, float centerY) {
        this.mCenterPointX = centerX;
        this.mCenterPointY = centerY;
    }

    public void setCenterPointXStep(float mCenterPointX) {
        this.mCenterPointXStep = mCenterPointX;
    }

    public void setCenterPointYStep(float mCenterPointY) {
        this.mCenterPointYStep = mCenterPointY;
    }

    public void setAlpha(float mAlpha) {
        this.mAlpha = mAlpha;
    }

    public void setAlphaTime(float mAlphaTime) {
        this.mAlphaTime = mAlphaTime;
    }

    public void setAlphaStep(float mAlphaStep) {
        this.mAlphaStep = mAlphaStep;
    }

    public void setShiftTime(float shiftTime) {
        this.mShiftTime = shiftTime;
    }

    public void setInitCenter(float initCenterX, float initCenterY) {
        this.mInitCenterX = initCenterX;
        this.mInitCenterY = initCenterY;
    }

    public void setStartTime(float startTime) {
        this.mStartTime = startTime;
    }

    public void reset() {
        this.mBitmapChanged = false;
        this.mDimHeight = 640.0f;
        this.mCenterPointX = 0.5f;
        this.mCenterPointY = 0.5f;
        this.mAlpha = 1.0f;
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mAlphaTime = 0.0f;
        this.mAlphaStep = 0.0f;
        this.mCenterPointXStep = 0.0f;
        this.mCenterPointYStep = 0.0f;
        this.mShiftTime = 0.0f;
        this.mStartTime = 0.0f;
    }
}

