/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.effect.PixellateFilter;

public class PolkaDotFilter
extends PixellateFilter {
    protected static final String UNIFORM_DOT_SCALING = "u_DotScaling";
    private int dotScalingHandle;
    private float dotScaling;

    public PolkaDotFilter(float dotScaling, float fractionalWidth, float aspectRatio) {
        super(fractionalWidth, aspectRatio);
        this.dotScaling = dotScaling;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_FractionalWidth;\nuniform float u_AspectRatio;\nuniform highp float u_DotScaling;\nvoid main(){\n   highp vec2 sampleDivisor = vec2(u_FractionalWidth, u_FractionalWidth /  u_AspectRatio);\n   highp vec2 samplePos = textureCoordinate - mod(textureCoordinate, sampleDivisor) + 0.5 * sampleDivisor;\n   highp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio));\n   highp vec2 adjustedSamplePos = vec2(samplePos.x, (samplePos.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio));\n   highp float distanceFromSamplePoint = distance(adjustedSamplePos, textureCoordinateToUse);\n   lowp float checkForPresenceWithinDot = step(distanceFromSamplePoint, (u_FractionalWidth * 0.5) * u_DotScaling);\n   gl_FragColor = vec4(texture2D(inputImageTexture0, samplePos ).rgb * checkForPresenceWithinDot, 1.0);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.dotScalingHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_DOT_SCALING);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.dotScalingHandle, (float)this.dotScaling);
    }
}

