/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class PixellateFilter
extends BasicFilter {
    protected static final String UNIFORM_FRACTIONAL_WIDTH = "u_FractionalWidth";
    protected static final String UNIFORM_ASPECT_RATIO = "u_AspectRatio";
    private int fractionalWidthHandle;
    private int aspectRatioHandle;
    private float fractionalWidth;
    private float aspectRatio;

    public PixellateFilter(float fractionalWidth, float aspectRatio) {
        this.fractionalWidth = fractionalWidth;
        this.aspectRatio = aspectRatio;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_FractionalWidth;\nuniform float u_AspectRatio;\nvoid main(){\n   highp vec2 sampleDivisor = vec2(u_FractionalWidth, u_FractionalWidth / u_AspectRatio);\n   highp vec2 samplePos = textureCoordinate - mod(textureCoordinate, sampleDivisor) + 0.5 * sampleDivisor;\n   gl_FragColor = texture2D(inputImageTexture0, samplePos);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.fractionalWidthHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_FRACTIONAL_WIDTH);
        this.aspectRatioHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ASPECT_RATIO);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.fractionalWidthHandle, (float)this.fractionalWidth);
        GLES20.glUniform1f((int)this.aspectRatioHandle, (float)this.aspectRatio);
    }
}

