/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.model.FilterOptions;

public class MosaicFilter2
extends AbsEffectOptionFilter {
    private final String UNIFORM_TILE_SIZE = "tile_size";
    private final String UNIFORM_RATIO = "ratio";
    private int ratioHandle;
    private int tileSizeHandle;
    private float tileSize = 0.5f;
    String fragmentShader = "varying vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform float tile_size;\nuniform float ratio;\n\nvoid main()\n{\n   vec2 mos_texCoord;\n   if(tile_size > 0.0) {\n       float factor = 25.0 / tile_size;\n       mos_texCoord = floor(textureCoordinate * vec2(factor * ratio, factor))/vec2(factor * ratio, factor);\n   } else {\n       mos_texCoord = textureCoordinate;\n   }\n   gl_FragColor = texture2D(inputImageTexture, mos_texCoord);\n}";

    @Override
    protected String getFragmentShader() {
        return this.fragmentShader;
    }

    @Override
    public void setFilterOptions(FilterOptions options) {
        super.setFilterOptions(options);
        this.tileSize = options.getBlockSize();
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.tileSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"tile_size");
        this.ratioHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"ratio");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.tileSizeHandle, (float)this.tileSize);
        GLES20.glUniform1f((int)this.ratioHandle, (float)((float)this.getWidth() / (float)this.getHeight()));
    }
}

