/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import java.io.File;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.ImageColorChangingFilter;
import project.android.imageprocessing.filter.effect.ImageScaleFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ImageScaleWithColorChangingFilter
extends GroupFilter
implements IVideoTrackTime {
    private boolean hasChanged = false;
    private long lastFrameTime = -1L;
    private long currentTime = -1L;
    ImageScaleFilter imageScaleFilter;
    ImageColorChangingFilter imageColorChangingFilter = new ImageColorChangingFilter();
    private String lookupPath1;
    private String lookupPath2;
    private String lookupPath3;
    private boolean noBitmap = true;
    private Bitmap lookup1;
    private Bitmap lookup2;
    private Bitmap lookup3;

    public ImageScaleWithColorChangingFilter() {
        this.imageScaleFilter = new ImageScaleFilter();
        this.imageColorChangingFilter.addTarget(this.imageScaleFilter);
        this.imageScaleFilter.addTarget(this);
        this.registerInitialFilter(this.imageColorChangingFilter);
        this.registerTerminalFilter(this.imageScaleFilter);
    }

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = this.currentTime;
        }
        if (this.hasChanged) {
            long l = this.currentTime - this.lastFrameTime;
            if (l > 1000L) {
                this.imageScaleFilter.setScale(0.9259259f);
            } else {
                this.imageScaleFilter.setScale(1.0f / (1.0f + (float)l / 1000.0f * 0.08f));
            }
            if (l > 300L && this.noBitmap && this.lookup1 != null) {
                this.imageColorChangingFilter.setLookupBitmap(this.lookup1);
                this.imageColorChangingFilter.setIntensity(0.0f);
                this.noBitmap = false;
            }
            if (l > 300L && l <= 1000L && !this.noBitmap) {
                this.imageColorChangingFilter.setIntensity((float)(l - 300L) / 700.0f);
            }
            if (l > 1100L && this.lookup2 != null) {
                this.imageColorChangingFilter.setLookupBitmap(this.lookup2);
                this.imageColorChangingFilter.setIntensity(1.0f);
            }
            if (l > 2000L && this.lookup3 != null) {
                this.imageColorChangingFilter.setLookupBitmap(this.lookup3);
                this.imageColorChangingFilter.setIntensity(1.0f);
            }
        }
        super.newTextureReady(texture, source, newData);
    }

    public synchronized void startAnimation() {
        this.lastFrameTime = -1L;
        this.hasChanged = true;
        this.imageScaleFilter.setScale(1.0f);
        this.imageColorChangingFilter.setLookupBitmap(null);
        this.imageColorChangingFilter.setIntensity(0.0f);
        this.noBitmap = true;
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.lookup1 != null && !this.lookup1.isRecycled()) {
            this.lookup1.recycle();
            this.lookup1 = null;
        }
        if (this.lookup2 != null && !this.lookup2.isRecycled()) {
            this.lookup2.recycle();
            this.lookup2 = null;
        }
        if (this.lookup3 != null && !this.lookup3.isRecycled()) {
            this.lookup3.recycle();
            this.lookup3 = null;
        }
    }

    private boolean exist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return new File(path).exists();
    }

    public synchronized void setLookupPath(String path) {
        this.lookupPath1 = path + "/lookup1.jpg";
        this.lookupPath2 = path + "/lookup2.jpg";
        this.lookupPath3 = path + "/lookup3.jpg";
        if (this.exist(this.lookupPath1)) {
            this.lookup1 = BitmapFactory.decodeFile((String)this.lookupPath1);
        }
        if (this.exist(this.lookupPath2)) {
            this.lookup2 = BitmapFactory.decodeFile((String)this.lookupPath2);
        }
        if (this.exist(this.lookupPath3)) {
            this.lookup3 = BitmapFactory.decodeFile((String)this.lookupPath3);
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        this.currentTime = ms;
    }
}

