/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.filter.BasicFilter;

public class ImageScaleFilter
extends BasicFilter {
    private FloatBuffer textureCoordBuffer = null;
    private float scale = 1.0f;

    @Override
    protected void passShaderValues() {
        this.calculateTextureCoordinates();
        if (this.textureCoordBuffer != null) {
            this.renderVertices.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            this.textureCoordBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureCoordBuffer);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.texture_in);
            GLES20.glUniform1i((int)this.textureHandle, (int)0);
        } else {
            super.passShaderValues();
        }
    }

    public synchronized void setScale(float scale) {
        this.scale = scale;
    }

    private synchronized void calculateTextureCoordinates() {
        float[] fArray = new float[8];
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(fArray);
        float f = (1.0f - this.scale) / 2.0f;
        float f2 = (1.0f - this.scale) / 2.0f;
        this.textureCoordBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        if (this.curRotation % 2 != 0) {
            for (int i = 0; i < 4; ++i) {
                float f3 = fArray[i * 2];
                fArray[i * 2] = (double)f3 < 0.5 ? f3 + f : f3 - f;
                f3 = fArray[i * 2 + 1];
                fArray[i * 2 + 1] = (double)f3 < 0.5 ? f3 + f2 : f3 - f2;
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                float f4 = fArray[i * 2];
                fArray[i * 2] = (double)f4 < 0.5 ? f4 + f2 : f4 - f2;
                f4 = fArray[i * 2 + 1];
                fArray[i * 2 + 1] = (double)f4 < 0.5 ? f4 + f : f4 - f;
            }
        }
        this.textureCoordBuffer.position(0);
        this.textureCoordBuffer.put(fArray);
        this.textureCoordBuffer.position(0);
    }
}

