/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.NormalFilter;
import project.android.imageprocessing.filter.effect.BasicBlendFilter;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class ImageMoveStickerBlendFilter
extends GroupFilter
implements IVideoTrackTime {
    private BasicBlendFilter mBasicBlendFilter;
    private BasicFilter mBasicFilter;

    public ImageMoveStickerBlendFilter(BasicFilter maskFilter) {
        if (maskFilter instanceof IVideoTrackTime) {
            this.mBasicFilter = maskFilter;
        }
        NormalFilter normalFilter = new NormalFilter();
        this.mBasicBlendFilter = new BasicBlendFilter();
        normalFilter.addTarget(this.mBasicBlendFilter);
        maskFilter.addTarget(this.mBasicBlendFilter);
        this.mBasicBlendFilter.registerFilterLocation(normalFilter, 0);
        this.mBasicBlendFilter.registerFilterLocation(maskFilter, 1);
        this.mBasicBlendFilter.addTarget(this);
        this.registerInitialFilter(normalFilter);
        this.registerInitialFilter(maskFilter);
        this.registerTerminalFilter(this.mBasicBlendFilter);
    }

    public void setStartAnimation() {
        this.mBasicBlendFilter.reset();
    }

    public void setStartTime(float time) {
        this.mBasicBlendFilter.setStartTime(time);
    }

    public void setAlphaInfo(float alpha, float alphaStep) {
        this.mBasicBlendFilter.setAlpha(alpha);
        this.mBasicBlendFilter.setAlphaStep(alphaStep);
    }

    @Override
    public void setTimeStamp(long ms) {
        if (null != this.mBasicFilter && this.mBasicFilter instanceof IVideoTrackTime) {
            ((IVideoTrackTime)((Object)this.mBasicFilter)).setTimeStamp(ms);
        }
    }

    public void setBlendMode(String blendMode) {
        if (this.mBasicBlendFilter != null) {
            this.mBasicBlendFilter.setBlendType(blendMode);
        }
    }
}

