/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import project.android.imageprocessing.filter.effect.PixellateFilter;

public class HalftoneFilter
extends PixellateFilter {
    public HalftoneFilter(float fractionalWidth, float aspectRatio) {
        super(fractionalWidth, aspectRatio);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform float u_FractionalWidth;\nuniform float u_AspectRatio;\nconst highp vec3 W = vec3(0.2125, 0.7154, 0.0721);\nvoid main(){\n   highp vec2 sampleDivisor = vec2(u_FractionalWidth, u_FractionalWidth /  u_AspectRatio);\n   highp vec2 samplePos = textureCoordinate - mod(textureCoordinate, sampleDivisor) + 0.5 * sampleDivisor;\n   highp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio));\n   highp vec2 adjustedSamplePos = vec2(samplePos.x, (samplePos.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio));\n   highp float distanceFromSamplePoint = distance(adjustedSamplePos, textureCoordinateToUse);\n   lowp vec3 sampledColor = texture2D(inputImageTexture0, samplePos ).rgb;\n   highp float dotScaling = 1.0 - dot(sampledColor, W);\n   lowp float checkForPresenceWithinDot = 1.0 - step(distanceFromSamplePoint, (u_FractionalWidth * 0.5) * dotScaling);\n   gl_FragColor = vec4(vec3(checkForPresenceWithinDot), 1.0);\n}\n";
    }
}

