/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import project.android.imageprocessing.filter.effect.SphereRefractionFilter;

public class GlassSphereFilter
extends SphereRefractionFilter {
    public GlassSphereFilter(PointF center, float radius, float refractiveIndex, float aspectRatio) {
        super(center, radius, refractiveIndex, aspectRatio);
    }

    @Override
    protected String getFragmentShader() {
        return "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform vec2 u_Center;\nuniform float u_Radius;\nuniform float u_DistortionAmount;\nuniform float u_AspectRatio;\nconst highp vec3 lightPosition = vec3(-0.5, 0.5, 1.0);\nconst highp vec3 ambientLightPosition = vec3(0.0, 0.0, 1.0);\nvoid main(){\n\tvec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio));\n\tfloat distanceFromCenter = distance(u_Center, textureCoordinateToUse);\n \tfloat checkForPresenceWithinSphere = step(distanceFromCenter, u_Radius);\n \tdistanceFromCenter = distanceFromCenter / u_Radius;\n \tfloat normalizedDepth = u_Radius * sqrt(1.0 - distanceFromCenter * distanceFromCenter);\n \tvec3 sphereNormal = normalize(vec3(textureCoordinateToUse - u_Center, normalizedDepth));\n \tvec3 refractedVector = 2.0 * refract(vec3(0.0, 0.0, -1.0), sphereNormal, u_DistortionAmount);\n\trefractedVector.xy = -refractedVector.xy;\n \tvec3 finalSphereColor = texture2D(inputImageTexture0, (refractedVector.xy + 1.0) * 0.5).rgb;\n\tfloat lightingIntensity = 2.5 * (1.0 - pow(clamp(dot(ambientLightPosition, sphereNormal), 0.0, 1.0), 0.25));\n\tfinalSphereColor += lightingIntensity;\n\tlightingIntensity  = clamp(dot(normalize(lightPosition), sphereNormal), 0.0, 1.0);\n\tlightingIntensity  = pow(lightingIntensity, 15.0);\n\tfinalSphereColor += vec3(0.8, 0.8, 0.8) * lightingIntensity;\n\tgl_FragColor = vec4(finalSphereColor, 1.0) * checkForPresenceWithinSphere;\n}\n";
    }
}

