/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import android.opengl.GLES20;
import android.opengl.Matrix;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.filter.effect.FilterTransUtils;

public class FuzzyGradShiftFilter
extends BasicFilter {
    protected static final String UNIFORM_SCALE_STEP = "scaleStep";
    protected int mScaleHandle;
    protected int mStepHandle;
    protected float[] texData0 = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    protected float mShift = 0.5f;
    protected float mVertexScale = 1.0f;
    protected float mScaleStep = 0.0f;
    protected float mShiftStep = 0.0f;
    protected float mInitScale = 1.0f;
    protected float mFinalScale = 1.0f;
    protected boolean mVarySpeed = false;
    protected FilterTransUtils filterTransUtils;
    protected float mFrameTime = 0.04f;
    protected float mTotalTime;
    protected float mStartTime;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n  uniform float scaleStep;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale > 1.0 || scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    vec2 uv2 = scaleFromCenter(uv, scaleStep);\n    gl_FragColor = texture2D(inputImageTexture0, uv2);\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mStepHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SCALE_STEP);
    }

    @Override
    protected void passShaderValues() {
        this.mTotalTime += this.mFrameTime;
        this.setAnimationProcess();
        super.passShaderValues();
        if (this.mVarySpeed) {
            if (this.mTotalTime <= 3.0f) {
                this.mInitScale = this.filterTransUtils.evaluateAtTimeIn(this.mTotalTime);
            }
        } else if (this.mTotalTime > this.mStartTime) {
            this.mInitScale += this.mScaleStep;
            if (this.mScaleStep > 0.0f) {
                if (this.mInitScale > 1.0f) {
                    this.mInitScale = 1.0f;
                }
            } else if (this.mInitScale < this.mFinalScale) {
                this.mInitScale = this.mFinalScale;
            }
        }
        GLES20.glUniform1f((int)this.mStepHandle, (float)this.mInitScale);
    }

    protected void setAnimationProcess() {
        if (this.mTotalTime >= this.mStartTime) {
            this.mShift += this.mShiftStep;
            if (this.mShift > this.mVertexScale / 2.0f) {
                this.mShift = this.mVertexScale / 2.0f;
            }
        }
        float[] fArray = this.setParamForMatrix(this.mVertexScale, this.mVertexScale, new PointF(this.mShift, 0.5f));
        this.setRenderVertices(fArray);
    }

    protected float[] setParamForMatrix(float w, float h, PointF centerPoint) {
        if (centerPoint == null) {
            return null;
        }
        float f = w;
        float f2 = h;
        float f3 = -(centerPoint.x * 2.0f - 1.0f);
        float f4 = -centerPoint.y * 2.0f + 1.0f;
        float[] fArray = new float[16];
        float[] fArray2 = new float[16];
        Matrix.setIdentityM((float[])fArray2, (int)0);
        Matrix.setIdentityM((float[])fArray, (int)0);
        Matrix.translateM((float[])fArray2, (int)0, (float)(-f3), (float)f4, (float)0.0f);
        Matrix.multiplyMM((float[])fArray, (int)0, (float[])fArray2, (int)0, (float[])fArray, (int)0);
        Matrix.scaleM((float[])fArray, (int)0, (float)(f * 1.0f), (float)(f2 * 1.0f), (float)1.0f);
        Matrix.multiplyMM((float[])fArray2, (int)0, (float[])fArray, (int)0, (float[])this.texData0, (int)0);
        float[] fArray3 = new float[]{fArray2[0], fArray2[1], fArray2[4], fArray2[5], fArray2[8], fArray2[9], fArray2[12], fArray2[13]};
        return fArray3;
    }

    public void setShift(float mShift) {
        this.mShift = mShift;
    }

    public void setVertexScale(float mVertexScale) {
        this.mVertexScale = 1.0f + 2.0f * (mVertexScale - 1.0f);
    }

    public void setScaleStep(float mScaleStep) {
        this.mScaleStep = mScaleStep;
    }

    public void setShiftStep(float mShiftStep) {
        this.mShiftStep = mShiftStep;
    }

    public void setInitScale(float scale) {
        this.mInitScale = scale;
    }

    public void setFinalScale(float scale) {
        this.mFinalScale = scale;
    }

    public void setUseVarySpeed(boolean varySpeed) {
        this.mVarySpeed = varySpeed;
        this.filterTransUtils = new FilterTransUtils(this.mInitScale, 1.0f, 3.0f);
        this.mFrameTime = 0.04f;
    }

    public synchronized void startAnimation() {
        this.mShift = 0.5f;
        this.mVertexScale = 1.0f;
        this.mScaleStep = 0.0f;
        this.mShiftStep = 0.0f;
        this.mInitScale = 1.0f;
        this.mFinalScale = 1.0f;
        this.mVarySpeed = false;
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mStartTime = 0.0f;
    }

    public void setShiftStartTime(float startTime) {
        this.mStartTime = startTime;
        this.mFrameTime = 0.04f;
    }

    public void setStartTime(float startTime) {
        this.mStartTime = startTime;
        this.mFrameTime = 0.04f;
    }
}

