/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import project.android.imageprocessing.filter.effect.FrameAdaptFilter;

public class FrameAdpterBlurFilter
extends FrameAdaptFilter {
    protected static final String UNIFORM_SCALE = "scale";
    protected int mScaleHandle;
    protected float[] texData0 = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n  uniform float scale;\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale > 1.0 || scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    uv.y = 1.0 - uv.y;\n    if (uv.x >=  0.0  && uv.x <= 1.0        && uv.y >= 0.0 && uv.y <= 1.0) {\n    gl_FragColor = texture2D(inputImageTexture0, uv);\n    } else {\n    vec2 newCoord = scaleFromCenter(uv, scale);\n    gl_FragColor = texture2D(inputImageTexture0,newCoord, 7.0);\n    }\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.mScaleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SCALE);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        float f = (float)this.getWidth() / (float)this.getHeight() * (this.sourceHeight / this.sourceWidth);
        GLES20.glUniform1f((int)this.mScaleHandle, (float)f);
    }

    @Override
    public synchronized int bitmapToTexture(Bitmap bitmap) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9987.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9987.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        GLES20.glGenerateMipmap((int)3553);
        return nArray[0];
    }

    @Override
    public synchronized void setImageInfo(Bitmap image) {
        super.setImageInfo(image);
    }
}

