/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import project.android.imageprocessing.filter.BasicFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;

public class FrameAdaptFilter
extends BasicFilter {
    private float hScalRatio = 1.0f;
    private float wScalRatio = 1.0f;
    protected float sourceWidth;
    protected float sourceHeight;
    private float targetWidth;
    private float targetHeight;
    protected float hOffset;
    protected float wOffset;
    protected FloatBuffer textureCoordBuffer = null;
    protected Bitmap mBitmap = null;
    protected boolean hasNewBitmap = false;

    @Override
    public void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (newData) {
            this.markAsDirty();
        }
        this.setWidth(source.getWidth());
        this.setHeight(source.getHeight());
        this.onDrawFrame();
        source.unlockRenderBuffer();
    }

    @Override
    protected void passShaderValues() {
        if (this.hasNewBitmap && this.mBitmap != null) {
            GLES20.glFinish();
            GLES20.glFinish();
            if (this.texture_in != 0) {
                int[] nArray = new int[]{this.texture_in};
                GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            }
            this.texture_in = this.bitmapToTexture(this.mBitmap);
            this.hasNewBitmap = false;
            this.handleSizeChange();
        }
        if (this.mBitmap == null) {
            GLES20.glClearColor((float)this.getBackgroundRed(), (float)this.getBackgroundGreen(), (float)this.getBackgroundBlue(), (float)this.getBackgroundAlpha());
            GLES20.glClear((int)16640);
        }
        if (this.textureCoordBuffer != null) {
            this.renderVertices.position(0);
            GLES20.glVertexAttribPointer((int)this.positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.renderVertices);
            GLES20.glEnableVertexAttribArray((int)this.positionHandle);
            this.textureCoordBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureCoordBuffer);
            GLES20.glEnableVertexAttribArray((int)this.texCoordHandle);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.texture_in);
            GLES20.glUniform1i((int)this.textureHandle, (int)0);
        } else {
            super.passShaderValues();
        }
    }

    private void caculateTargetSize() {
        if (this.mBitmap != null) {
            this.sourceHeight = this.mBitmap.getHeight();
            this.sourceWidth = this.mBitmap.getWidth();
        }
        float f = this.sourceWidth * 1.0f / (float)this.getWidth();
        float f2 = this.sourceHeight * 1.0f / (float)this.getHeight();
        float f3 = f2 > f && this.sourceHeight / this.sourceWidth < 1.7777778f ? f2 : f;
        this.targetWidth = (float)this.getWidth() * f3;
        this.targetHeight = (float)this.getHeight() * f3;
    }

    @Override
    protected void handleSizeChange() {
        float[] fArray = new float[8];
        this.textureVertices[this.curRotation].position(0);
        this.textureVertices[this.curRotation].get(fArray);
        this.caculateTargetSize();
        this.wScalRatio = this.targetWidth / this.sourceWidth;
        this.hScalRatio = this.targetHeight / this.sourceHeight;
        this.hOffset = (1.0f - this.hScalRatio) / 2.0f;
        this.wOffset = (1.0f - this.wScalRatio) / 2.0f;
        this.textureCoordBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        for (int i = 0; i < 4; ++i) {
            float f = fArray[i * 2];
            fArray[i * 2] = (double)f <= 0.5 ? f + this.wOffset : f - this.wOffset;
            f = fArray[i * 2 + 1];
            fArray[i * 2 + 1] = (double)f <= 0.5 ? f + this.hOffset : f - this.hOffset;
        }
        this.textureCoordBuffer.position(0);
        this.textureCoordBuffer.put(fArray);
        this.textureCoordBuffer.position(0);
        super.handleSizeChange();
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nvoid main(){\n    vec2 uv = textureCoordinate;\n    uv.y = 1.0 -uv.y;\n    if (uv.x > 0.0 && uv.x < 1.0        && uv.y > 0.0 && uv.y < 1.0) {    gl_FragColor = texture2D(inputImageTexture0, uv);\n    }}\n";
        return string;
    }

    public synchronized void setImageInfo(Bitmap image) {
        this.mBitmap = image;
        this.hasNewBitmap = true;
    }

    public synchronized int bitmapToTexture(Bitmap bitmap) {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glBindTexture((int)3553, (int)nArray[0]);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        if (bitmap != null) {
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        }
        return nArray[0];
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    @Override
    public void releaseFrameBuffer() {
        super.releaseFrameBuffer();
        if (this.texture_in != 0) {
            int[] nArray = new int[]{this.texture_in};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        }
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }
}

