/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

public class FilterTransUtils {
    private float begin = 0.0f;
    private float end = 0.0f;
    private float duration = 0.0f;
    private float transferRange = 0.0f;

    public FilterTransUtils(float begin, float end, float duration) {
        this.begin = begin;
        this.end = end;
        this.duration = duration;
        this.transferRange = this.end - this.begin;
    }

    public float evaluateAtTimeInOut(float time) {
        if ((time /= this.duration / 2.0f) < 1.0f) {
            return this.transferRange / 2.0f * time * time + this.begin;
        }
        return -this.transferRange / 2.0f * ((time -= 1.0f) * (time - 2.0f) - 1.0f) + this.begin;
    }

    public float evaluateAtTimeIn(float time) {
        return this.transferRange * (time /= this.duration) * time + this.begin;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }
}

