/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import java.io.File;
import project.android.imageprocessing.filter.GroupFilter;
import project.android.imageprocessing.filter.colour.ImageColorChangingFilter;
import project.android.imageprocessing.filter.effect.DownwardFilter;
import project.android.imageprocessing.filter.effect.FrameAdpterBlurFilter;
import project.android.imageprocessing.input.GLTextureOutputRenderer;
import project.android.imageprocessing.inter.IVideoTrackTime;

public class DownwardWithColorFilter
extends GroupFilter
implements IVideoTrackTime {
    private boolean hasChanged = false;
    private long lastFrameTime = -1L;
    private long currentTime = -1L;
    String colorPath;
    Bitmap lookup;
    private float offset = 0.0f;
    private FrameAdpterBlurFilter frameAdaptFilterBefore;
    private FrameAdpterBlurFilter frameAdaptFilterAfter;
    private DownwardFilter downwardFilter;
    private ImageColorChangingFilter imageColorChangingFilter = new ImageColorChangingFilter();

    public DownwardWithColorFilter() {
        this.frameAdaptFilterBefore = new FrameAdpterBlurFilter();
        this.frameAdaptFilterAfter = new FrameAdpterBlurFilter();
        this.downwardFilter = new DownwardFilter();
        this.downwardFilter.setFullDown(true);
        this.frameAdaptFilterBefore.addTarget(this.downwardFilter);
        this.frameAdaptFilterAfter.addTarget(this.imageColorChangingFilter);
        this.imageColorChangingFilter.addTarget(this.downwardFilter);
        this.downwardFilter.registerFilterLocation(this.frameAdaptFilterBefore, 0);
        this.downwardFilter.registerFilterLocation(this.imageColorChangingFilter, 1);
        this.downwardFilter.addTarget(this);
        this.registerInitialFilter(this.frameAdaptFilterBefore);
        this.registerInitialFilter(this.frameAdaptFilterAfter);
        this.registerTerminalFilter(this.downwardFilter);
    }

    @Override
    public synchronized void newTextureReady(int texture, GLTextureOutputRenderer source, boolean newData) {
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = this.currentTime;
        }
        if (this.hasChanged) {
            long l = this.currentTime - this.lastFrameTime;
            this.offset = l < 500L ? (float)l / 500.0f : 1.0f;
            this.downwardFilter.setOffset(this.offset);
            if (l < 1000L) {
                this.imageColorChangingFilter.setIntensity(0.0f);
            } else if (l < 1500L) {
                this.imageColorChangingFilter.setIntensity((float)(l - 1000L) / 500.0f);
            } else {
                this.imageColorChangingFilter.setIntensity(1.0f);
            }
        }
        super.newTextureReady(texture, source, newData);
    }

    public void setTransferFieldImage(Bitmap bitmapBefore, Bitmap bitmapAfter) {
        if (this.frameAdaptFilterBefore != null && this.frameAdaptFilterAfter != null) {
            this.frameAdaptFilterBefore.setImageInfo(bitmapBefore);
            this.frameAdaptFilterAfter.setImageInfo(bitmapAfter);
        }
        this.startAnimation();
    }

    private synchronized void startAnimation() {
        this.lastFrameTime = -1L;
        this.hasChanged = true;
        this.imageColorChangingFilter.setIntensity(0.0f);
        this.downwardFilter.setOffset(0.0f);
    }

    @Override
    public synchronized void destroy() {
        if (this.lookup != null && !this.lookup.isRecycled()) {
            this.lookup.recycle();
        }
        super.destroy();
    }

    private boolean exist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return new File(path).exists();
    }

    public synchronized void setLookupPath(String path) {
        this.colorPath = path + "/lookup2.jpg";
        if (this.exist(this.colorPath)) {
            this.lookup = BitmapFactory.decodeFile((String)this.colorPath);
        }
        if (this.lookup != null) {
            this.imageColorChangingFilter.setLookupBitmap(this.lookup);
            this.imageColorChangingFilter.setIntensity(0.0f);
        }
    }

    @Override
    public void setTimeStamp(long ms) {
        this.currentTime = ms;
    }
}

