/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;

public class DownwardFilter
extends MultiInputFilter {
    private float offset = 0.0f;
    private float mixture = 1.0f;
    private float fullDown = 0.0f;
    private int offsetHandler;
    private int mixtureHandler;
    private int fullDownHandler;

    public DownwardFilter() {
        super(2);
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float offset;\nuniform float mixture;\nuniform float fullDown;\nvoid main(){\n  vec2 uv = textureCoordinate;\n  vec4 texColour2 = texture2D(inputImageTexture0,uv);\n  vec4 texColour = texture2D(inputImageTexture1,uv);\n  vec4 texColour3 = mix(texColour2,texColour,mixture);\n  if (uv.y < (1.0-offset)) {\n  gl_FragColor = texColour2;} else{\n  if (fullDown > 0.5){ \n   vec2 uv1 = vec2(uv.x, uv.y + offset - 1.0 );\n   texColour3 = texture2D(inputImageTexture1,uv1);\n  }\n  gl_FragColor = texColour3;}\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.offsetHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"offset");
        this.mixtureHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"mixture");
        this.fullDownHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)"fullDown");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform1f((int)this.offsetHandler, (float)this.offset);
        GLES20.glUniform1f((int)this.mixtureHandler, (float)this.mixture);
        GLES20.glUniform1f((int)this.fullDownHandler, (float)this.fullDown);
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    public void setMixture(float mixture) {
        this.mixture = mixture;
    }

    public void setFullDown(boolean isFullDown) {
        this.fullDown = isFullDown ? 1.0f : 0.0f;
    }
}

