/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import android.util.Log;
import project.android.imageprocessing.filter.BasicFilter;

public class DotScreenFilter
extends BasicFilter {
    final String UNIFORM_TEXTURE_SIZE = "textureSize";
    final String UNIFORM_SCALE = "scale";
    final String UNIFORM_ANGLES = "angles";
    final String UNIFORM_SINGLE_MODE = "singleAngleMode";
    private float scale = 9.0f;
    private float angles = 0.7853982f;
    private int textureSizeHandle;
    private int scaleHandle;
    private int angleHandle;
    private int singleModeHandle;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform vec2 textureSize;\nuniform float scale;\nuniform float angles;\n mat2 rotm(float r) {\n        float cr = cos(r);\n        float sr = sin(r);\n        return mat2(vec2(cr, -sr), vec2(sr, cr));\n    }\n\n    vec2 samplePosition(vec2 textureCoordinate, mat2 m, float scale){\n        vec2 rotatedTextureCoordinate = m * textureCoordinate;\n        return (rotatedTextureCoordinate - mod(textureCoordinate, vec2(scale)) + scale * 0.5) * m;\n    }\n\n    float halftoneIntensity(vec2 textureCoordinate, vec2 samplePos, float scale, vec3 grayColorTransform, vec4 color){\n        float grayscale = dot(color.rgb, grayColorTransform);\n        float d = scale * 1.414214 * (1.0 - grayscale);\n        float d1 = distance(textureCoordinate + vec2(-0.25), samplePos);\n        float d2 = distance(textureCoordinate + vec2(0.25, -0.25), samplePos);\n        float d3 = distance(textureCoordinate + vec2(-0.25, 0.25), samplePos);\n        float d4 = distance(textureCoordinate + vec2(0.25), samplePos);\n        return dot(vec4(lessThan(vec4(d1, d2, d3, d4), vec4(d/2.0))), vec4(0.25));\n    }\n\n    vec2 neighborSamplePosition(vec2 textureCoordinate, vec2 samplePosition, float scale, mat2 m){\n        vec2 p = (textureCoordinate - samplePosition) * m;\n        vec2 direction = (p.y > p.x) ? (-p.x > p.y ? vec2(-1, 0) :vec2(0, 1)) : (-p.y > p.x ? vec2(0, -1):vec2(1, 0));\n        return samplePosition + (m * direction) * scale;\n\n    }\n\n    void main(){\n        vec2 textureCoordinatePos = textureCoordinate * textureSize;\n        vec4 texCoordColor =texture2D(inputImageTexture0, textureCoordinate);\n        vec3 gray = vec3(0.299, 0.587, 0.114);\n        mat2 m = rotm(angles);\n        vec2 rotatedTextureCoordinate = m * textureCoordinatePos;\n        vec2 samplePos = (rotatedTextureCoordinate - mod(rotatedTextureCoordinate, vec2(scale)) + scale*0.5)*m;\n        vec4 color = texture2D(inputImageTexture0,  samplePos/textureSize);\n        float intensity = halftoneIntensity(textureCoordinatePos, samplePos, scale, gray, color);\n        vec2 samplePosNeighbor =  neighborSamplePosition(textureCoordinatePos, samplePos, scale, m);\n color = texture2D(inputImageTexture0,  samplePosNeighbor/textureSize);\n        float intensityNeighbor = halftoneIntensity(textureCoordinatePos, samplePosNeighbor, scale, gray, color);\n        float i = (1.0 - intensity) * (1.0 - intensityNeighbor);\n        gl_FragColor = vec4(vec3(i), texCoordColor.a);\n    }\n";
        Log.i((String)"shader", (String)string);
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.textureSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"textureSize");
        this.scaleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"scale");
        this.angleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"angles");
        this.singleModeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"singleAngleMode");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.textureSizeHandle, (float)this.getWidth(), (float)this.getHeight());
        GLES20.glUniform1f((int)this.scaleHandle, (float)this.scale);
        GLES20.glUniform1f((int)this.angleHandle, (float)this.angles);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setAngles(float xAngle) {
        this.angles = xAngle;
    }
}

