/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.AbsEffectOptionFilter;
import project.android.imageprocessing.model.FilterOptions;

public class CrosshatchFilter2
extends AbsEffectOptionFilter {
    final String UNIFORM_TEXTURE_SIZE = "textureSize";
    final String UNIFORM_TILE_SIZE = "tile_size";
    private int textureSizeHandle;
    private int tileSizeHandle;
    private float tileSize = 5.0f;
    String fragmentShader = "varying vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n uniform vec2 textureSize;\n\nuniform float tile_size;\nvec4 fragColor;\n\nvoid main()\n{\n     float lum = length(texture2D(inputImageTexture, textureCoordinate).rgb);\n     fragColor = vec4(1.0, 1.0, 1.0, 1.0);\n     \n     if (lum < 1.00) {\n         if (mod(floor(textureCoordinate.x*textureSize.y + textureCoordinate.y*textureSize.x), tile_size) == 0.0) {\n             fragColor = vec4(0.0, 0.0, 0.0, 1.0);\n         }\n     }\n     \n     if (lum < 0.75) {\n         if (mod(floor(textureCoordinate.x*textureSize.y - textureCoordinate.y*textureSize.x), tile_size) == 0.0) {\n             fragColor = vec4(0.0, 0.0, 0.0, 1.0);\n         }\n     }\n     \n     if (lum < 0.50) {\n         if (mod(floor(textureCoordinate.x*textureSize.y + textureCoordinate.y*textureSize.x -tile_size/2.), tile_size) == 0.0) {\n             fragColor = vec4(0.0, 0.0, 0.0, 1.0);\n         }\n     }\n     \n     if (lum < 0.3) {\n         if (mod(floor(textureCoordinate.x*textureSize.y - textureCoordinate.y*textureSize.x -tile_size/2.), tile_size) == 0.0) {\n             fragColor = vec4(0.0, 0.0, 0.0, 1.0);\n         }\n     }\n     gl_FragColor = fragColor;\n}\n";

    @Override
    protected String getFragmentShader() {
        return this.fragmentShader;
    }

    @Override
    public void setFilterOptions(FilterOptions options) {
        super.setFilterOptions(options);
        this.tileSize = options.getAmount();
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.textureSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"textureSize");
        this.tileSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"tile_size");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.textureSizeHandle, (float)this.getWidth(), (float)this.getHeight());
        GLES20.glUniform1f((int)this.tileSizeHandle, (float)this.tileSize);
    }
}

