/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import android.util.Log;
import project.android.imageprocessing.filter.BasicFilter;

public class ColorHalftoneFilter
extends BasicFilter {
    final String UNIFORM_TEXTURE_SIZE = "textureSize";
    final String UNIFORM_SCALE = "scale";
    final String UNIFORM_ANGLES = "angles";
    final String UNIFORM_SINGLE_MODE = "singleAngleMode";
    private float scale = 20.0f;
    private float[] angles = new float[]{0.7853982f, 0.7853982f, 0.7853982f, 0.0f};
    private boolean singleMode;
    private int textureSizeHandle;
    private int scaleHandle;
    private int angleHandle;
    private int singleModeHandle;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n uniform vec2 textureSize;\nuniform float scale;\nuniform vec4 angles;\nuniform int singleAngleMode;\n mat2 rotm(float r) {\n        float cr = cos(r);\n        float sr = sin(r);\n        return mat2(vec2(cr, -sr), vec2(sr, cr));\n    }\n\n    vec2 samplePosition(vec2 textureCoordinate, mat2 m, float scale){\n        vec2 rotatedTextureCoordinate = m * textureCoordinate;\n        return (rotatedTextureCoordinate - mod(textureCoordinate, vec2(scale)) + scale * 0.5) * m;\n    }\n\n    float halftoneIntensity(vec2 textureCoordinate, vec2 samplePos, float scale, vec3 grayColorTransform, vec4 color){\n        float grayscale = dot(color.rgb, grayColorTransform);\n        float d = scale * 1.414214 * (1.0 - grayscale);\n        float d1 = distance(textureCoordinate + vec2(-0.25), samplePos);\n        float d2 = distance(textureCoordinate + vec2(0.25, -0.25), samplePos);\n        float d3 = distance(textureCoordinate + vec2(-0.25, 0.25), samplePos);\n        float d4 = distance(textureCoordinate + vec2(0.25), samplePos);\n        return dot(vec4(lessThan(vec4(d1, d2, d3, d4), vec4(d/2.0))), vec4(0.25));\n    }\n\n    vec3 halftoneIntensityRGB(vec2 textureCoordinate, vec2 samplePos, vec4 color, float scale){\n        vec3 d = scale * 1.414214 * (1.0 - color.rgb);\n        float d1 = distance(textureCoordinate + vec2(-0.25), samplePos);\n        float d2 = distance(textureCoordinate + vec2(0.25, -0.25), samplePos);\n        float d3 = distance(textureCoordinate + vec2(-0.25, 0.25), samplePos);\n        float d4 = distance(textureCoordinate + vec2(0.25), samplePos);\n        vec4 dis = vec4(d1, d2, d3, d4);\n        vec4 ra = vec4(0.25);\n        return vec3(dot(vec4(lessThan(dis, vec4(d.r/2.0))), ra),\n        dot(vec4(lessThan(dis, vec4(d.g/2.0))), ra),\n        dot(vec4(lessThan(dis, vec4(d.b/2.0))), ra));\n    }\n\n    vec2 neighborSamplePosition(vec2 textureCoordinate, vec2 samplePosition, float scale, mat2 m){\n        vec2 p = (textureCoordinate - samplePosition) * m;\n        vec2 direction = (p.y > p.x) ? (-p.x > p.y ? vec2(-1, 0) :vec2(0, 1)) : (-p.y > p.x ? vec2(0, -1):vec2(1, 0));\n        return samplePosition + (m * direction) * scale;\n\n    }\n\n    void main(){\n        vec3 intensityRGB;\n        vec3 intensityNeighborRGB;\n        vec2 textureCoordinatePos = textureCoordinate * textureSize;\n        vec4 texCoordColor =texture2D(inputImageTexture0, textureCoordinate);\n        if(singleAngleMode == 1){\n            mat2 m = rotm(angles.x);\n            vec2 samplePos = samplePosition(textureCoordinatePos, m, scale);\n            vec4 color =texture2D(inputImageTexture0, samplePos/textureSize);\n            intensityRGB = halftoneIntensityRGB(textureCoordinatePos, samplePos, color, scale);\n            samplePos = neighborSamplePosition(textureCoordinatePos, samplePos, scale, m);            color = texture2D(inputImageTexture0, samplePos/textureSize);\n            intensityNeighborRGB = halftoneIntensityRGB(textureCoordinatePos, samplePos, color, scale);\n        }else{\n            mat2 mr = rotm(angles.x);\n            mat2 mg = rotm(angles.y);\n            mat2 mb = rotm(angles.z);\n            vec2 samplePositionR = samplePosition(textureCoordinatePos, mr, scale);\n            vec2 samplePositionG = samplePosition(textureCoordinatePos, mg, scale);\n            vec2 samplePositionB = samplePosition(textureCoordinatePos, mb, scale);\n\n            vec4 color1 = texture2D(inputImageTexture0, samplePositionR/textureSize);\n            vec4 color2 = texture2D(inputImageTexture0, samplePositionG/textureSize);\n            vec4 color3 = texture2D(inputImageTexture0, samplePositionB/textureSize);\n\n            intensityRGB = vec3(halftoneIntensityRGB(textureCoordinatePos, samplePositionR, color1, scale).r,\n                                halftoneIntensityRGB(textureCoordinatePos, samplePositionG, color2, scale).g,\n                                halftoneIntensityRGB(textureCoordinatePos, samplePositionB, color3, scale).b);\n\n            samplePositionR = neighborSamplePosition(textureCoordinatePos, samplePositionR, scale, mr);\n            samplePositionG = neighborSamplePosition(textureCoordinatePos, samplePositionG, scale, mg);\n            samplePositionB = neighborSamplePosition(textureCoordinatePos, samplePositionB, scale, mb);\n\n            color1 = texture2D(inputImageTexture0, samplePositionR/textureSize);\n            color2 = texture2D(inputImageTexture0, samplePositionG/textureSize);\n            color3 = texture2D(inputImageTexture0, samplePositionB/textureSize);\n\n            intensityNeighborRGB = vec3(halftoneIntensityRGB(textureCoordinatePos, samplePositionR, color1, scale).r,\n                                        halftoneIntensityRGB(textureCoordinatePos, samplePositionG, color2, scale).g,\n                                        halftoneIntensityRGB(textureCoordinatePos, samplePositionB, color3, scale).b);\n        }\n        vec3 i = (1.0 - intensityRGB) * (1.0 - intensityNeighborRGB);\n        gl_FragColor = vec4(i, texCoordColor.a);\n    }\n";
        Log.i((String)"shader", (String)string);
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.textureSizeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"textureSize");
        this.scaleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"scale");
        this.angleHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"angles");
        this.singleModeHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"singleAngleMode");
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.textureSizeHandle, (float)this.getWidth(), (float)this.getHeight());
        GLES20.glUniform1f((int)this.scaleHandle, (float)this.scale);
        if (this.angles.length > 0 && this.angles[0] == this.angles[1] && this.angles[1] == this.angles[2]) {
            GLES20.glUniform1i((int)this.singleModeHandle, (int)1);
        } else {
            GLES20.glUniform1i((int)this.singleModeHandle, (int)0);
        }
        GLES20.glUniform4f((int)this.angleHandle, (float)this.angles[0], (float)this.angles[1], (float)this.angles[2], (float)this.angles[3]);
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setAngles(float xAngle, float yAngle, float zAngle, float wAngle) {
        this.angles[0] = xAngle;
        this.angles[1] = yAngle;
        this.angles[2] = zAngle;
        this.angles[3] = wAngle;
    }

    public void setSingleMode(boolean singleMode) {
        this.singleMode = singleMode;
    }
}

