/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class CollapseFilter
extends BasicFilter {
    private int pointAHandle;
    private int pointBHandle;
    private int pointCHandle;
    private int pointDHandle;
    protected float mFrameTime = 0.04f;
    protected float mTotalTime = 0.0f;
    private float mStartTime = 0.0f;
    private float[] pointA = new float[]{0.0f, 0.0f};
    private float[] pointB = new float[]{1.0f, 0.0f};
    private float[] pointC = new float[]{1.0f, 1.0f};
    private float[] pointD = new float[]{0.0f, 1.0f};
    private float y = 0.0f;
    private float slope = 1.0f;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\n\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n\nuniform vec2 pointA;\nuniform vec2 pointB;\n\nuniform vec2 pointC;\nuniform vec2 pointD;\n\nfloat determinant(vec2 lv, vec2 rv) {\n    return lv.x * rv.y - lv.y * rv.x;\n}\n\nvoid main() {\n    vec2 tlv = textureCoordinate - pointA;\n    vec2 trv = pointB - pointA;\n    \n    vec2 blv = textureCoordinate - pointC;\n    vec2 brv = pointD - pointC;\n    \n    float tResult = sign(determinant(tlv, trv));\n    float bResult = sign(determinant(blv, brv));\n    if (tResult * bResult > 0.0) {\n        gl_FragColor = texture2D(inputImageTexture0, textureCoordinate);\n    } else {\n        vec4 color = texture2D(inputImageTexture0, textureCoordinate);\n        gl_FragColor = vec4(color.rgb * 0.5, 1.0);\n    }\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.pointAHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"pointA");
        this.pointBHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"pointB");
        this.pointCHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"pointC");
        this.pointDHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)"pointD");
    }

    @Override
    protected void passShaderValues() {
        this.mTotalTime += this.mFrameTime;
        super.passShaderValues();
        if (this.mTotalTime >= this.mStartTime) {
            float f;
            float f2 = this.mTotalTime - this.mStartTime;
            float f3 = this.y;
            if ((double)f3 < 0.5) {
                f3 = this.getSAtTime(1.0f, 0.5f, 0.7f, f2);
                this.y = f3 <= 0.5f ? f3 : 0.5f;
            }
            float f4 = this.slope;
            if (this.slope > 0.0f) {
                f4 = 1.0f - this.getSAtTime(2.0f, 1.0f, 0.7f, f2);
                this.slope = f4 >= 0.0f ? f4 : 0.0f;
            }
            this.pointA[0] = 0.0f;
            this.pointA[1] = 1.0f - this.y;
            float f5 = this.getXAtY(1.0f, this.slope, this.pointA);
            if (f5 < 1.0f) {
                this.pointB[0] = f5;
                this.pointB[1] = 1.0f;
            } else {
                f = this.getYAtX(1.0f, this.slope, this.pointA);
                this.pointB[0] = 1.0f;
                this.pointB[1] = f > 0.5f ? f : 0.5f;
            }
            this.pointC[0] = 1.0f;
            this.pointC[1] = this.y;
            f5 = this.getXAtY(0.0f, this.slope, this.pointC);
            if (f5 > 0.0f) {
                this.pointD[0] = f5;
                this.pointD[1] = 0.0f;
            } else {
                f = this.getYAtX(0.0f, this.slope, this.pointC);
                this.pointD[0] = 0.0f;
                this.pointD[1] = f < 0.5f ? f : 0.5f;
            }
        }
        GLES20.glUniform2fv((int)this.pointAHandle, (int)1, (float[])this.pointA, (int)0);
        GLES20.glUniform2fv((int)this.pointBHandle, (int)1, (float[])this.pointB, (int)0);
        GLES20.glUniform2fv((int)this.pointCHandle, (int)1, (float[])this.pointC, (int)0);
        GLES20.glUniform2fv((int)this.pointDHandle, (int)1, (float[])this.pointD, (int)0);
    }

    private float getXAtY(float y, float slope, float[] point) {
        return (y - point[1]) / slope + point[0];
    }

    private float getYAtX(float x, float slope, float[] point) {
        return slope * (x - point[0]) + point[1];
    }

    private float getSAtTime(float v0, float displacement, float totalTime, float time) {
        float f = (v0 * totalTime - displacement) * 2.0f / (totalTime * totalTime);
        return v0 * time - f * time * time / 2.0f;
    }

    public void setStartTime(float startTime) {
        this.mStartTime = startTime;
    }

    public synchronized void startAnimation() {
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mStartTime = 0.0f;
    }
}

