/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.graphics.PointF;
import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class BulgeDistortionFilter
extends BasicFilter {
    protected static final String UNIFORM_CENTER = "u_Center";
    protected static final String UNIFORM_RADIUS = "u_Radius";
    protected static final String UNIFORM_DISTORTION_AMOUNT = "u_DistortionAmount";
    protected static final String UNIFORM_ASPECT_RATIO = "u_AspectRatio";
    private int centerHandle;
    private int radiusHandle;
    private int distortionAmountHandle;
    private int aspectRatioHandle;
    private float radius;
    private PointF center;
    private float distortionAmount;
    private float aspectRatio;

    public BulgeDistortionFilter(PointF center, float radius, float distortionAmount, float aspectRatio) {
        this.center = center;
        this.radius = radius;
        this.distortionAmount = distortionAmount;
        this.aspectRatio = aspectRatio;
    }

    @Override
    protected String getFragmentShader() {
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\nuniform vec2 u_Center;\nuniform float u_Radius;\nuniform float u_DistortionAmount;\nuniform float u_AspectRatio;\nvoid main(){\n   highp vec2 textureCoordinateToUse = vec2(textureCoordinate.x, (textureCoordinate.y * u_AspectRatio + 0.5 - 0.5 * u_AspectRatio));\n   highp float dist = distance(u_Center, textureCoordinateToUse);\n   textureCoordinateToUse = textureCoordinate;\n   if (dist < u_Radius) {\n     textureCoordinateToUse -= u_Center;\n     highp float percent = 1.0 - (u_Radius - dist) / u_Radius * u_DistortionAmount;\n     percent = percent * percent;\n     textureCoordinateToUse = textureCoordinateToUse * percent;\n     textureCoordinateToUse += u_Center;\n   }\n   gl_FragColor = texture2D(inputImageTexture0, textureCoordinateToUse);\n}\n";
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.centerHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_CENTER);
        this.radiusHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_RADIUS);
        this.distortionAmountHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_DISTORTION_AMOUNT);
        this.aspectRatioHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ASPECT_RATIO);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        GLES20.glUniform2f((int)this.centerHandle, (float)this.center.x, (float)this.center.y);
        GLES20.glUniform1f((int)this.radiusHandle, (float)this.radius);
        GLES20.glUniform1f((int)this.distortionAmountHandle, (float)this.distortionAmount);
        GLES20.glUniform1f((int)this.aspectRatioHandle, (float)this.aspectRatio);
    }
}

