/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class BlurGradFilter
extends BasicFilter {
    private static final String UNIFORM_GRAD = "grad";
    private int gradHandle;
    protected float mFrameTime = 0.04f;
    protected float mTotalTime = 0.0f;
    private float mGradValue = 10.0f;
    private float mStartTime = 8.0f;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n  uniform float grad;\nvoid main(){\n    vec2 uv = textureCoordinate;\n    gl_FragColor = texture2D(inputImageTexture0,uv, grad);\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.gradHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_GRAD);
    }

    @Override
    protected void passShaderValues() {
        GLES20.glBindTexture((int)3553, (int)this.texture_in);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9987.0f);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9987.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GLES20.glGenerateMipmap((int)3553);
        this.mTotalTime += this.mFrameTime;
        super.passShaderValues();
        if (this.mTotalTime >= this.mStartTime) {
            this.mGradValue -= 1.0f;
            if (this.mGradValue < 0.0f) {
                this.mGradValue = 0.0f;
            }
        }
        GLES20.glUniform1f((int)this.gradHandle, (float)this.mGradValue);
    }

    public void setStartTime(float startTime) {
        this.mStartTime = startTime;
    }

    public synchronized void startAnimation() {
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mGradValue = 10.0f;
        this.mStartTime = 0.0f;
    }
}

