/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import android.text.TextUtils;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.helper.BlendShaderHelper;

public class BasicBlendFilter
extends MultiInputFilter {
    private static final String UNIFORM_BLEND = "blend";
    private int blendHandler;
    private static final String UNIFORM_ALPHA = "alpha";
    private int alphaHandler;
    private boolean isBlend = false;
    private boolean isMultiply = false;
    private String blendType;
    private float mStartTime = 0.0f;
    protected float mFrameTime = 0.04f;
    protected float mTotalTime = 0.0f;
    private float mAlpha = 1.0f;
    private float mAlphaStep = 0.0f;
    private String shaderMultiplyStr = "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform float blend;\nuniform float alpha;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 base = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = base; } else {     lowp vec4 overlayer = texture2D(inputImageTexture1,textureCoordinate) * alpha;\n          \n     gl_FragColor = overlayer * base + overlayer * (1.0 - base.a) + base * (1.0 - overlayer.a);\n}\n }";

    public void setBlendType(String blendType) {
        this.blendType = blendType;
    }

    public void setMultiply(boolean multiply) {
        this.isMultiply = multiply;
    }

    public BasicBlendFilter() {
        super(2);
    }

    public BasicBlendFilter(int numOfInputs) {
        super(numOfInputs);
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.blendHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_BLEND);
        this.alphaHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ALPHA);
    }

    @Override
    protected void passShaderValues() {
        this.mTotalTime += this.mFrameTime;
        super.passShaderValues();
        if (this.mTotalTime >= this.mStartTime) {
            this.isBlend = true;
            this.mAlpha += this.mAlphaStep;
            if (this.mAlpha > 1.0f) {
                this.mAlpha = 1.0f;
            }
        } else {
            this.isBlend = false;
        }
        GLES20.glUniform1f((int)this.blendHandler, (float)(this.isBlend ? 1.0f : 0.0f));
        GLES20.glUniform1f((int)this.alphaHandler, (float)this.mAlpha);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlend(boolean blend) {
        Object object = this.listLock;
        synchronized (object) {
            this.isBlend = blend;
        }
    }

    @Override
    protected String getFragmentShader() {
        String string;
        if (this.isMultiply) {
            return this.shaderMultiplyStr;
        }
        if (!(TextUtils.isEmpty((CharSequence)this.blendType) || this.blendType.equals("Normal") || TextUtils.isEmpty((CharSequence)(string = BlendShaderHelper.getBlendShader(this.blendType))))) {
            return string;
        }
        return "precision mediump float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nuniform float blend;\nvarying vec2 textureCoordinate;\nvoid main(){\n vec4 color2 = texture2D(inputImageTexture0,textureCoordinate);\n if(blend==0.0) {     gl_FragColor = color2; }  else{   vec4 color1 = texture2D(inputImageTexture1,textureCoordinate);\n   vec4 outputColor;\n   float a = color1.a + color2.a * (1.0 - color1.a);\n   outputColor.r = (color1.r * color1.a + color2.r * color2.a * (1.0 - color1.a))/a;\n   outputColor.g = (color1.g * color1.a + color2.g * color2.a * (1.0 - color1.a))/a;\n   outputColor.b = (color1.b * color1.a + color2.b * color2.a * (1.0 - color1.a))/a;\n   outputColor.a = 1.0;\n   gl_FragColor = outputColor;\n }}\n";
    }

    public void setStartTime(float time) {
        this.mStartTime = time;
    }

    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
    }

    public void setAlphaStep(float alphaStep) {
        this.mAlphaStep = alphaStep;
    }

    public void reset() {
        this.mStartTime = 0.0f;
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mAlpha = 1.0f;
        this.mAlphaStep = 0.0f;
    }
}

