/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.BasicFilter;

public class AlphaControlFilter
extends BasicFilter {
    private static final String UNIFORM_ALPHA = "alpha";
    private static final String UNIFORM_LIGHT = "light";
    private int alphaHandle;
    private int lightHandle;
    protected float mFrameTime = 0.04f;
    protected float mTotalTime = 0.0f;
    protected float mAlphaStartTime = 0.0f;
    private float mInitAlpha = 1.0f;
    private float mAlphaStep = 0.0f;
    private float mLight = 1.0f;
    private float mLightStep = 0.0f;
    private float mLightStartTime = 0.0f;
    private float mLightValue = 1.0f;

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nvarying vec2 textureCoordinate;\n  uniform float alpha;\n  uniform float light;\nvoid main(){\n    vec2 uv = textureCoordinate;\n    gl_FragColor = vec4(texture2D(inputImageTexture0, uv).rgb,alpha)*light;\n}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.alphaHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_ALPHA);
        this.lightHandle = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_LIGHT);
    }

    @Override
    public void drawSub() {
        if (this.mInitAlpha >= 1.0f) {
            super.drawSub();
        } else {
            GLES20.glEnable((int)3042);
            GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
            super.drawSub();
            GLES20.glDisable((int)3042);
        }
    }

    @Override
    protected void passShaderValues() {
        this.mTotalTime += this.mFrameTime;
        super.passShaderValues();
        if (this.mTotalTime > this.mAlphaStartTime) {
            this.mInitAlpha += this.mAlphaStep;
            if (this.mInitAlpha > 1.0f) {
                this.mInitAlpha = 1.0f;
            }
        }
        if (this.mTotalTime > this.mLightStartTime) {
            if (this.mLightStep > 0.0f) {
                this.mLight -= this.mLightStep;
                if (this.mLight < this.mLightValue) {
                    this.mLight = this.mLightValue;
                }
            } else {
                this.mLightValue -= this.mLightStep;
                this.mLight = this.mLightValue;
                if (this.mLight > 1.0f) {
                    this.mLight = 1.0f;
                }
            }
        }
        GLES20.glUniform1f((int)this.alphaHandle, (float)this.mInitAlpha);
        GLES20.glUniform1f((int)this.lightHandle, (float)this.mLight);
    }

    public synchronized void setAlphaStartTime(float startTime) {
        this.mAlphaStartTime = startTime;
    }

    public synchronized void setLightStartTime(float startTime) {
        this.mLightStartTime = startTime;
    }

    public synchronized void setInitAlpha(float alpha) {
        this.mInitAlpha = alpha;
    }

    public synchronized void setAlphaStep(float alphaStep) {
        this.mAlphaStep = alphaStep;
    }

    public synchronized void setLightValue(float lightValue) {
        this.mLightValue = lightValue;
    }

    public synchronized void setLightStep(float lightStep) {
        this.mLightStep = lightStep;
    }

    public synchronized void startAnimation() {
        this.mFrameTime = 0.04f;
        this.mTotalTime = 0.0f;
        this.mAlphaStartTime = 0.0f;
        this.mInitAlpha = 1.0f;
        this.mAlphaStep = 0.0f;
        this.mLight = 1.0f;
        this.mLightStep = 0.0f;
        this.mLightStartTime = 0.0f;
        this.mLightValue = 1.0f;
    }
}

