/*
 * Decompiled with CFR 0.152.
 */
package project.android.imageprocessing.filter.effect;

import android.opengl.GLES20;
import project.android.imageprocessing.filter.MultiInputFilter;
import project.android.imageprocessing.inter.MoveFilterInterface;

public class AlbumTemplateFilter
extends MultiInputFilter
implements MoveFilterInterface {
    public static final String UNIFORM_SHIFT_BOTTOM = "shiftBottom";
    public static final String UNIFORM_SHIFT2_BOTTOM = "shiftBottom2";
    public static final String UNIFORM_SHIFT3_BOTTOM = "shiftBottom3";
    public static final String UNIFORM_SHIFT_TOP = "shiftTop";
    public static final String UNIFORM_SHIFT2_TOP = "shiftTop2";
    public static final String UNIFORM_SHIFT3_TOP = "shiftTop3";
    public static final String UNIFORM_SHIFT_CETER = "shiftCenter";
    public static final String UNIFORM_SHIFT1_CETER = "shiftCenter1";
    public static final String UNIFORM_SHIFT = "shift";
    private int shiftBottomHandler;
    private int shiftBottom2Handler;
    private int shiftBottom3Handler;
    private int shiftTopHandler;
    private int shiftTop2Handler;
    private int shiftTop3Handler;
    private int shiftCenterHandler;
    private int shiftCenter1Handler;
    private int shiftHandler;
    private float offsetBottom = 0.0f;
    private float offsetBottom2 = 0.0f;
    private float offsetBottom3 = 0.0f;
    private float offsetTop = 0.0f;
    private float offsetTop2 = 0.0f;
    private float offsetTop3 = 0.0f;
    private float offsetCenter = 0.0f;
    private float offset1Center = 0.0f;
    private float offset = 0.5f;
    private boolean mHasChanged = true;
    private int mFrameRate = 25;

    public AlbumTemplateFilter() {
        super(2);
    }

    @Override
    protected String getFragmentShader() {
        String string = "precision highp float;\nuniform sampler2D inputImageTexture0;\nuniform sampler2D inputImageTexture1;\nvarying vec2 textureCoordinate;\nuniform float shiftBottom;\nuniform float shiftBottom2;\nuniform float shiftBottom3;\nuniform float shiftTop;\nuniform float shiftTop2;\nuniform float shiftTop3;\nuniform float shiftCenter;\nuniform float shiftCenter1;\nuniform float shift;\nconst vec3 W = vec3(0.2125,0.7154,0.0721);\nvec2 scaleFromCenter(vec2 coord, float scale) {\n  if (scale < 0.0) { return coord; }\n  vec2 scaleCenter = vec2(0.5);\n  return (coord - scaleCenter) * scale + scaleCenter;\n}\nvoid main(){\n    vec2 uv = textureCoordinate;\n    vec2 uv1 = textureCoordinate;\n    uv = scaleFromCenter(uv,shift);\n if (uv.y <= -0.2*uv.x + 0.4 ) {\n        if (uv.x < shiftBottom && uv.x > shiftBottom2) {\n          gl_FragColor = (texture2D(inputImageTexture0,uv)*vec4( 1.0,0.,0.,1.0));\n        }else if (uv.x < shiftBottom2 && uv.x > shiftBottom3) {\n          vec3 color = texture2D(inputImageTexture0,uv).rgb;\n          float luminace = dot(color,W);\n          gl_FragColor = vec4(luminace,luminace,luminace,1.0);\n        }else if (uv.x > shiftBottom){\n          gl_FragColor = texture2D(inputImageTexture1,uv1);\n        } else {\n          gl_FragColor = texture2D(inputImageTexture0,uv);\n        }\n    }else if (uv.y >= -0.2*uv.x + 0.8) {\n        if (uv.x < shiftTop && uv.x > shiftTop2) {\n          gl_FragColor = (texture2D(inputImageTexture0,uv)*vec4( 1.0,0.,0.,1.0));\n        }else if (uv.x < shiftTop2 && uv.x > shiftTop3) {\n          vec3 color = texture2D(inputImageTexture0,uv).rgb;\n          float luminace = dot(color,W);\n          gl_FragColor = vec4(luminace,luminace,luminace,1.0);\n        }else if (uv.x > shiftTop){\n          gl_FragColor = texture2D(inputImageTexture1,uv1);\n        } else {\n          gl_FragColor = texture2D(inputImageTexture0,uv);\n        }\n    } else {\n        if (uv.x > 1. - shiftCenter && uv.x < 1.0 -  shiftCenter1) {\n          gl_FragColor = (texture2D(inputImageTexture0,uv)*vec4( 1.0,0.,0.,1.0));\n        } else if (uv.x > 1.0 - shiftCenter){\n          gl_FragColor = texture2D(inputImageTexture0,uv);\n        }else {\n          gl_FragColor = texture2D(inputImageTexture1,uv1);\n        }\n    }}\n";
        return string;
    }

    @Override
    protected void initShaderHandles() {
        super.initShaderHandles();
        this.shiftBottomHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT_BOTTOM);
        this.shiftBottom2Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT2_BOTTOM);
        this.shiftBottom3Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT3_BOTTOM);
        this.shiftTopHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT_TOP);
        this.shiftTop2Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT2_TOP);
        this.shiftTop3Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT3_TOP);
        this.shiftCenterHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT_CETER);
        this.shiftCenter1Handler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT1_CETER);
        this.shiftHandler = GLES20.glGetUniformLocation((int)this.programHandle, (String)UNIFORM_SHIFT);
    }

    @Override
    protected void passShaderValues() {
        super.passShaderValues();
        if (this.mHasChanged) {
            this.offset += 0.2f / (float)this.mFrameRate;
            if ((double)this.offset >= 1.0) {
                this.offset = 1.0f;
            }
            this.offsetBottom += 2.0f / (float)this.mFrameRate;
            if ((double)this.offsetBottom >= 1.0) {
                this.offsetBottom = 1.0f;
            }
            if ((double)this.offsetBottom >= 0.8) {
                this.offsetBottom2 += 2.0f / (float)this.mFrameRate;
                if (this.offsetBottom2 >= 1.0f) {
                    this.offsetBottom2 = 1.0f;
                }
                if (this.offsetBottom2 >= 0.8f) {
                    this.offsetBottom3 += 4.0f / (float)this.mFrameRate;
                    if (this.offsetBottom3 >= 1.0f) {
                        this.offsetBottom3 = 1.0f;
                    }
                }
                this.offsetCenter += 2.0f / (float)this.mFrameRate;
                if (this.offsetCenter >= 1.0f) {
                    this.offsetCenter = 1.0f;
                }
                if (this.offsetCenter > 0.6f) {
                    this.offset1Center += 2.0f / (float)this.mFrameRate;
                    if (this.offset1Center >= 1.0f) {
                        this.offset1Center = 1.0f;
                    }
                }
                this.offsetTop += 2.0f / (float)this.mFrameRate;
                if (this.offsetTop >= 1.0f) {
                    this.offsetTop = 1.0f;
                }
                if (this.offsetTop > 0.9f) {
                    this.offsetTop2 += 2.0f / (float)this.mFrameRate;
                    if (this.offsetTop2 >= 1.0f) {
                        this.offsetTop2 = 1.0f;
                    }
                }
                if (this.offsetTop2 >= 0.7f) {
                    this.offsetTop3 += 4.0f / (float)this.mFrameRate;
                    if (this.offsetTop3 >= 1.0f) {
                        this.offsetTop3 = 1.0f;
                        this.mHasChanged = false;
                    }
                }
            }
        }
        GLES20.glUniform1f((int)this.shiftBottomHandler, (float)this.offsetBottom);
        GLES20.glUniform1f((int)this.shiftBottom2Handler, (float)this.offsetBottom2);
        GLES20.glUniform1f((int)this.shiftBottom3Handler, (float)this.offsetBottom3);
        GLES20.glUniform1f((int)this.shiftTopHandler, (float)this.offsetTop);
        GLES20.glUniform1f((int)this.shiftTop2Handler, (float)this.offsetTop2);
        GLES20.glUniform1f((int)this.shiftTop3Handler, (float)this.offsetTop3);
        GLES20.glUniform1f((int)this.shiftCenterHandler, (float)this.offsetCenter);
        GLES20.glUniform1f((int)this.shiftCenter1Handler, (float)this.offset1Center);
        GLES20.glUniform1f((int)this.shiftHandler, (float)this.offset);
    }

    @Override
    public void textureChanged(boolean hasChanged) {
        this.mHasChanged = hasChanged;
        this.offsetBottom = 0.0f;
        this.offsetBottom2 = 0.0f;
        this.offsetBottom3 = 0.0f;
        this.offsetTop = 0.0f;
        this.offsetTop2 = 0.0f;
        this.offsetTop3 = 0.0f;
        this.offsetCenter = 0.0f;
        this.offset1Center = 0.0f;
    }

    @Override
    public void setFrameRate(int rate) {
        this.mFrameRate = rate;
    }
}

